<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirSeason StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AirSeason
 * @subpackage Structs
 */
class AirSeason extends DictionaryBase
{
    /**
     * The CharterKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CharterKey;
    /**
     * The DateBegin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateBegin;
    /**
     * The DateEnd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateEnd;
    /**
     * The TimeBegin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TimeBegin;
    /**
     * The TimeEnd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TimeEnd;
    /**
     * The WeekDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WeekDays;
    /**
     * Constructor method for AirSeason
     * @uses AirSeason::setCharterKey()
     * @uses AirSeason::setDateBegin()
     * @uses AirSeason::setDateEnd()
     * @uses AirSeason::setTimeBegin()
     * @uses AirSeason::setTimeEnd()
     * @uses AirSeason::setWeekDays()
     * @param int $charterKey
     * @param string $dateBegin
     * @param string $dateEnd
     * @param string $timeBegin
     * @param string $timeEnd
     * @param string $weekDays
     */
    public function __construct($charterKey = null, $dateBegin = null, $dateEnd = null, $timeBegin = null, $timeEnd = null, $weekDays = null)
    {
        $this
            ->setCharterKey($charterKey)
            ->setDateBegin($dateBegin)
            ->setDateEnd($dateEnd)
            ->setTimeBegin($timeBegin)
            ->setTimeEnd($timeEnd)
            ->setWeekDays($weekDays);
    }
    /**
     * Get CharterKey value
     * @return int|null
     */
    public function getCharterKey()
    {
        return $this->CharterKey;
    }
    /**
     * Set CharterKey value
     * @param int $charterKey
     * @return \StructType\AirSeason
     */
    public function setCharterKey($charterKey = null)
    {
        // validation for constraint: int
        if (!is_null($charterKey) && !(is_int($charterKey) || ctype_digit($charterKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($charterKey, true), gettype($charterKey)), __LINE__);
        }
        $this->CharterKey = $charterKey;
        return $this;
    }
    /**
     * Get DateBegin value
     * @return string|null
     */
    public function getDateBegin()
    {
        return $this->DateBegin;
    }
    /**
     * Set DateBegin value
     * @param string $dateBegin
     * @return \StructType\AirSeason
     */
    public function setDateBegin($dateBegin = null)
    {
        // validation for constraint: string
        if (!is_null($dateBegin) && !is_string($dateBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateBegin, true), gettype($dateBegin)), __LINE__);
        }
        $this->DateBegin = $dateBegin;
        return $this;
    }
    /**
     * Get DateEnd value
     * @return string|null
     */
    public function getDateEnd()
    {
        return $this->DateEnd;
    }
    /**
     * Set DateEnd value
     * @param string $dateEnd
     * @return \StructType\AirSeason
     */
    public function setDateEnd($dateEnd = null)
    {
        // validation for constraint: string
        if (!is_null($dateEnd) && !is_string($dateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateEnd, true), gettype($dateEnd)), __LINE__);
        }
        $this->DateEnd = $dateEnd;
        return $this;
    }
    /**
     * Get TimeBegin value
     * @return string|null
     */
    public function getTimeBegin()
    {
        return $this->TimeBegin;
    }
    /**
     * Set TimeBegin value
     * @param string $timeBegin
     * @return \StructType\AirSeason
     */
    public function setTimeBegin($timeBegin = null)
    {
        // validation for constraint: string
        if (!is_null($timeBegin) && !is_string($timeBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeBegin, true), gettype($timeBegin)), __LINE__);
        }
        $this->TimeBegin = $timeBegin;
        return $this;
    }
    /**
     * Get TimeEnd value
     * @return string|null
     */
    public function getTimeEnd()
    {
        return $this->TimeEnd;
    }
    /**
     * Set TimeEnd value
     * @param string $timeEnd
     * @return \StructType\AirSeason
     */
    public function setTimeEnd($timeEnd = null)
    {
        // validation for constraint: string
        if (!is_null($timeEnd) && !is_string($timeEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeEnd, true), gettype($timeEnd)), __LINE__);
        }
        $this->TimeEnd = $timeEnd;
        return $this;
    }
    /**
     * Get WeekDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWeekDays()
    {
        return isset($this->WeekDays) ? $this->WeekDays : null;
    }
    /**
     * Set WeekDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $weekDays
     * @return \StructType\AirSeason
     */
    public function setWeekDays($weekDays = null)
    {
        // validation for constraint: string
        if (!is_null($weekDays) && !is_string($weekDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weekDays, true), gettype($weekDays)), __LINE__);
        }
        if (is_null($weekDays) || (is_array($weekDays) && empty($weekDays))) {
            unset($this->WeekDays);
        } else {
            $this->WeekDays = $weekDays;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirSeason
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
