<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccommodationAge StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccommodationAge
 * @subpackage Structs
 */
class AccommodationAge extends DictionaryBase
{
    /**
     * The ACA_ACKEY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ACA_ACKEY;
    /**
     * The ACA_AGEFROM
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ACA_AGEFROM;
    /**
     * The ACA_AGETO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ACA_AGETO;
    /**
     * The ACA_ISMAIN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ACA_ISMAIN;
    /**
     * The ACA_NMEN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ACA_NMEN;
    /**
     * Constructor method for AccommodationAge
     * @uses AccommodationAge::setACA_ACKEY()
     * @uses AccommodationAge::setACA_AGEFROM()
     * @uses AccommodationAge::setACA_AGETO()
     * @uses AccommodationAge::setACA_ISMAIN()
     * @uses AccommodationAge::setACA_NMEN()
     * @param int $aCA_ACKEY
     * @param int $aCA_AGEFROM
     * @param int $aCA_AGETO
     * @param bool $aCA_ISMAIN
     * @param int $aCA_NMEN
     */
    public function __construct($aCA_ACKEY = null, $aCA_AGEFROM = null, $aCA_AGETO = null, $aCA_ISMAIN = null, $aCA_NMEN = null)
    {
        $this
            ->setACA_ACKEY($aCA_ACKEY)
            ->setACA_AGEFROM($aCA_AGEFROM)
            ->setACA_AGETO($aCA_AGETO)
            ->setACA_ISMAIN($aCA_ISMAIN)
            ->setACA_NMEN($aCA_NMEN);
    }
    /**
     * Get ACA_ACKEY value
     * @return int|null
     */
    public function getACA_ACKEY()
    {
        return $this->ACA_ACKEY;
    }
    /**
     * Set ACA_ACKEY value
     * @param int $aCA_ACKEY
     * @return \StructType\AccommodationAge
     */
    public function setACA_ACKEY($aCA_ACKEY = null)
    {
        // validation for constraint: int
        if (!is_null($aCA_ACKEY) && !(is_int($aCA_ACKEY) || ctype_digit($aCA_ACKEY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aCA_ACKEY, true), gettype($aCA_ACKEY)), __LINE__);
        }
        $this->ACA_ACKEY = $aCA_ACKEY;
        return $this;
    }
    /**
     * Get ACA_AGEFROM value
     * @return int|null
     */
    public function getACA_AGEFROM()
    {
        return $this->ACA_AGEFROM;
    }
    /**
     * Set ACA_AGEFROM value
     * @param int $aCA_AGEFROM
     * @return \StructType\AccommodationAge
     */
    public function setACA_AGEFROM($aCA_AGEFROM = null)
    {
        // validation for constraint: int
        if (!is_null($aCA_AGEFROM) && !(is_int($aCA_AGEFROM) || ctype_digit($aCA_AGEFROM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aCA_AGEFROM, true), gettype($aCA_AGEFROM)), __LINE__);
        }
        $this->ACA_AGEFROM = $aCA_AGEFROM;
        return $this;
    }
    /**
     * Get ACA_AGETO value
     * @return int|null
     */
    public function getACA_AGETO()
    {
        return $this->ACA_AGETO;
    }
    /**
     * Set ACA_AGETO value
     * @param int $aCA_AGETO
     * @return \StructType\AccommodationAge
     */
    public function setACA_AGETO($aCA_AGETO = null)
    {
        // validation for constraint: int
        if (!is_null($aCA_AGETO) && !(is_int($aCA_AGETO) || ctype_digit($aCA_AGETO))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aCA_AGETO, true), gettype($aCA_AGETO)), __LINE__);
        }
        $this->ACA_AGETO = $aCA_AGETO;
        return $this;
    }
    /**
     * Get ACA_ISMAIN value
     * @return bool|null
     */
    public function getACA_ISMAIN()
    {
        return $this->ACA_ISMAIN;
    }
    /**
     * Set ACA_ISMAIN value
     * @param bool $aCA_ISMAIN
     * @return \StructType\AccommodationAge
     */
    public function setACA_ISMAIN($aCA_ISMAIN = null)
    {
        // validation for constraint: boolean
        if (!is_null($aCA_ISMAIN) && !is_bool($aCA_ISMAIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aCA_ISMAIN, true), gettype($aCA_ISMAIN)), __LINE__);
        }
        $this->ACA_ISMAIN = $aCA_ISMAIN;
        return $this;
    }
    /**
     * Get ACA_NMEN value
     * @return int|null
     */
    public function getACA_NMEN()
    {
        return $this->ACA_NMEN;
    }
    /**
     * Set ACA_NMEN value
     * @param int $aCA_NMEN
     * @return \StructType\AccommodationAge
     */
    public function setACA_NMEN($aCA_NMEN = null)
    {
        // validation for constraint: int
        if (!is_null($aCA_NMEN) && !(is_int($aCA_NMEN) || ctype_digit($aCA_NMEN))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aCA_NMEN, true), gettype($aCA_NMEN)), __LINE__);
        }
        $this->ACA_NMEN = $aCA_NMEN;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccommodationAge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
