<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Accommodation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Accommodation
 * @subpackage Structs
 */
class Accommodation extends DictionaryBase
{
    /**
     * The AccommodationAges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAccommodationAge
     */
    public $AccommodationAges;
    /**
     * The Age1From
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Age1From;
    /**
     * The Age1To
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Age1To;
    /**
     * The Age2From
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Age2From;
    /**
     * The Age2To
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Age2To;
    /**
     * The PlaceAdult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PlaceAdult;
    /**
     * The PlaceChild
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PlaceChild;
    /**
     * Constructor method for Accommodation
     * @uses Accommodation::setAccommodationAges()
     * @uses Accommodation::setAge1From()
     * @uses Accommodation::setAge1To()
     * @uses Accommodation::setAge2From()
     * @uses Accommodation::setAge2To()
     * @uses Accommodation::setPlaceAdult()
     * @uses Accommodation::setPlaceChild()
     * @param \ArrayType\ArrayOfAccommodationAge $accommodationAges
     * @param int $age1From
     * @param int $age1To
     * @param int $age2From
     * @param int $age2To
     * @param int $placeAdult
     * @param int $placeChild
     */
    public function __construct(\ArrayType\ArrayOfAccommodationAge $accommodationAges = null, $age1From = null, $age1To = null, $age2From = null, $age2To = null, $placeAdult = null, $placeChild = null)
    {
        $this
            ->setAccommodationAges($accommodationAges)
            ->setAge1From($age1From)
            ->setAge1To($age1To)
            ->setAge2From($age2From)
            ->setAge2To($age2To)
            ->setPlaceAdult($placeAdult)
            ->setPlaceChild($placeChild);
    }
    /**
     * Get AccommodationAges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAccommodationAge|null
     */
    public function getAccommodationAges()
    {
        return isset($this->AccommodationAges) ? $this->AccommodationAges : null;
    }
    /**
     * Set AccommodationAges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAccommodationAge $accommodationAges
     * @return \StructType\Accommodation
     */
    public function setAccommodationAges(\ArrayType\ArrayOfAccommodationAge $accommodationAges = null)
    {
        if (is_null($accommodationAges) || (is_array($accommodationAges) && empty($accommodationAges))) {
            unset($this->AccommodationAges);
        } else {
            $this->AccommodationAges = $accommodationAges;
        }
        return $this;
    }
    /**
     * Get Age1From value
     * @return int|null
     */
    public function getAge1From()
    {
        return $this->Age1From;
    }
    /**
     * Set Age1From value
     * @param int $age1From
     * @return \StructType\Accommodation
     */
    public function setAge1From($age1From = null)
    {
        // validation for constraint: int
        if (!is_null($age1From) && !(is_int($age1From) || ctype_digit($age1From))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age1From, true), gettype($age1From)), __LINE__);
        }
        $this->Age1From = $age1From;
        return $this;
    }
    /**
     * Get Age1To value
     * @return int|null
     */
    public function getAge1To()
    {
        return $this->Age1To;
    }
    /**
     * Set Age1To value
     * @param int $age1To
     * @return \StructType\Accommodation
     */
    public function setAge1To($age1To = null)
    {
        // validation for constraint: int
        if (!is_null($age1To) && !(is_int($age1To) || ctype_digit($age1To))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age1To, true), gettype($age1To)), __LINE__);
        }
        $this->Age1To = $age1To;
        return $this;
    }
    /**
     * Get Age2From value
     * @return int|null
     */
    public function getAge2From()
    {
        return $this->Age2From;
    }
    /**
     * Set Age2From value
     * @param int $age2From
     * @return \StructType\Accommodation
     */
    public function setAge2From($age2From = null)
    {
        // validation for constraint: int
        if (!is_null($age2From) && !(is_int($age2From) || ctype_digit($age2From))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age2From, true), gettype($age2From)), __LINE__);
        }
        $this->Age2From = $age2From;
        return $this;
    }
    /**
     * Get Age2To value
     * @return int|null
     */
    public function getAge2To()
    {
        return $this->Age2To;
    }
    /**
     * Set Age2To value
     * @param int $age2To
     * @return \StructType\Accommodation
     */
    public function setAge2To($age2To = null)
    {
        // validation for constraint: int
        if (!is_null($age2To) && !(is_int($age2To) || ctype_digit($age2To))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age2To, true), gettype($age2To)), __LINE__);
        }
        $this->Age2To = $age2To;
        return $this;
    }
    /**
     * Get PlaceAdult value
     * @return int|null
     */
    public function getPlaceAdult()
    {
        return $this->PlaceAdult;
    }
    /**
     * Set PlaceAdult value
     * @param int $placeAdult
     * @return \StructType\Accommodation
     */
    public function setPlaceAdult($placeAdult = null)
    {
        // validation for constraint: int
        if (!is_null($placeAdult) && !(is_int($placeAdult) || ctype_digit($placeAdult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($placeAdult, true), gettype($placeAdult)), __LINE__);
        }
        $this->PlaceAdult = $placeAdult;
        return $this;
    }
    /**
     * Get PlaceChild value
     * @return int|null
     */
    public function getPlaceChild()
    {
        return $this->PlaceChild;
    }
    /**
     * Set PlaceChild value
     * @param int $placeChild
     * @return \StructType\Accommodation
     */
    public function setPlaceChild($placeChild = null)
    {
        // validation for constraint: int
        if (!is_null($placeChild) && !(is_int($placeChild) || ctype_digit($placeChild))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($placeChild, true), gettype($placeChild)), __LINE__);
        }
        $this->PlaceChild = $placeChild;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Accommodation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
