<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetData $parameters
     * @return \StructType\GetDataResponse|bool
     */
    public function GetData(\StructType\GetData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDataDistinctHotels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDataDistinctHotels $parameters
     * @return \StructType\GetDataDistinctHotelsResponse|bool
     */
    public function GetDataDistinctHotels(\StructType\GetDataDistinctHotels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDataDistinctHotels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMinPrices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMinPrices $parameters
     * @return \StructType\GetMinPricesResponse|bool
     */
    public function GetMinPrices(\StructType\GetMinPrices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMinPrices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFilter $parameters
     * @return \StructType\GetFilterResponse|bool
     */
    public function GetFilter(\StructType\GetFilter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFilter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFilter2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFilter2 $parameters
     * @return \StructType\GetFilter2Response|bool
     */
    public function GetFilter2(\StructType\GetFilter2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFilter2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFilter3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFilter3 $parameters
     * @return \StructType\GetFilter3Response|bool
     */
    public function GetFilter3(\StructType\GetFilter3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFilter3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFilter4
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFilter4 $parameters
     * @return \StructType\GetFilter4Response|bool
     */
    public function GetFilter4(\StructType\GetFilter4 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFilter4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFilter5
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFilter5 $parameters
     * @return \StructType\GetFilter5Response|bool
     */
    public function GetFilter5(\StructType\GetFilter5 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFilter5($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCountries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCountries $parameters
     * @return \StructType\GetCountriesResponse|bool
     */
    public function GetCountries(\StructType\GetCountries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCountries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTourDirections
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTourDirections $parameters
     * @return \StructType\GetTourDirectionsResponse|bool
     */
    public function GetTourDirections(\StructType\GetTourDirections $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTourDirections($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCityDeparture
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCityDeparture $parameters
     * @return \StructType\GetCityDepartureResponse|bool
     */
    public function GetCityDeparture(\StructType\GetCityDeparture $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCityDeparture($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCityDepartureByTypeTour
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCityDepartureByTypeTour $parameters
     * @return \StructType\GetCityDepartureByTypeTourResponse|bool
     */
    public function GetCityDepartureByTypeTour(\StructType\GetCityDepartureByTypeTour $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCityDepartureByTypeTour($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBaseDictionary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBaseDictionary $parameters
     * @return \StructType\GetBaseDictionaryResponse|bool
     */
    public function GetBaseDictionary(\StructType\GetBaseDictionary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBaseDictionary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDictionary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDictionary $parameters
     * @return \StructType\GetDictionaryResponse|bool
     */
    public function GetDictionary(\StructType\GetDictionary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDictionary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDictionaries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDictionaries $parameters
     * @return \StructType\GetDictionariesResponse|bool
     */
    public function GetDictionaries(\StructType\GetDictionaries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDictionaries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStat $parameters
     * @return \StructType\GetStatResponse|bool
     */
    public function GetStat(\StructType\GetStat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCourse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCourse $parameters
     * @return \StructType\GetCourseResponse|bool
     */
    public function GetCourse(\StructType\GetCourse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCourse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPricesPerPax
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPricesPerPax $parameters
     * @return \StructType\GetPricesPerPaxResponse|bool
     */
    public function GetPricesPerPax(\StructType\GetPricesPerPax $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPricesPerPax($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTourDirectionList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTourDirectionList $parameters
     * @return \StructType\GetTourDirectionListResponse|bool
     */
    public function GetTourDirectionList(\StructType\GetTourDirectionList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTourDirectionList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetBaseDictionaryResponse|\StructType\GetCityDepartureByTypeTourResponse|\StructType\GetCityDepartureResponse|\StructType\GetCountriesResponse|\StructType\GetCourseResponse|\StructType\GetDataDistinctHotelsResponse|\StructType\GetDataResponse|\StructType\GetDictionariesResponse|\StructType\GetDictionaryResponse|\StructType\GetFilter2Response|\StructType\GetFilter3Response|\StructType\GetFilter4Response|\StructType\GetFilter5Response|\StructType\GetFilterResponse|\StructType\GetMinPricesResponse|\StructType\GetPricesPerPaxResponse|\StructType\GetStatResponse|\StructType\GetTourDirectionListResponse|\StructType\GetTourDirectionsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
