<?php

namespace EnumType;

/**
 * This class stands for TransportKind EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransportKind
 * @subpackage Enumerations
 */
class TransportKind
{
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'Avia'
     * @return string 'Avia'
     */
    const VALUE_AVIA = 'Avia';
    /**
     * Constant for value 'Bus'
     * @return string 'Bus'
     */
    const VALUE_BUS = 'Bus';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_AVIA
     * @uses self::VALUE_BUS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_AVIA,
            self::VALUE_BUS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
