<?php

namespace EnumType;

/**
 * This class stands for QuotaState EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QuotaState
 * @subpackage Enumerations
 */
class QuotaState
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Little'
     * @return string 'Little'
     */
    const VALUE_LITTLE = 'Little';
    /**
     * Constant for value 'Ok'
     * @return string 'Ok'
     */
    const VALUE_OK = 'Ok';
    /**
     * Constant for value 'OkLittle'
     * @return string 'OkLittle'
     */
    const VALUE_OK_LITTLE = 'OkLittle';
    /**
     * Constant for value 'Wait'
     * @return string 'Wait'
     */
    const VALUE_WAIT = 'Wait';
    /**
     * Constant for value 'Stop'
     * @return string 'Stop'
     */
    const VALUE_STOP = 'Stop';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_LITTLE
     * @uses self::VALUE_OK
     * @uses self::VALUE_OK_LITTLE
     * @uses self::VALUE_WAIT
     * @uses self::VALUE_STOP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_LITTLE,
            self::VALUE_OK,
            self::VALUE_OK_LITTLE,
            self::VALUE_WAIT,
            self::VALUE_STOP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
