<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfshort ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfshort
 * @subpackage Arrays
 */
class ArrayOfshort extends AbstractStructArrayBase
{
    /**
     * The short
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $short;
    /**
     * Constructor method for ArrayOfshort
     * @uses ArrayOfshort::setShort()
     * @param int[] $short
     */
    public function __construct(array $short = array())
    {
        $this
            ->setShort($short);
    }
    /**
     * Get short value
     * @return int[]|null
     */
    public function getShort()
    {
        return $this->short;
    }
    /**
     * This method is responsible for validating the values passed to the setShort method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShort method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShortForArrayConstraintsFromSetShort(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfshortShortItem) {
            // validation for constraint: itemType
            if (!(is_int($arrayOfshortShortItem) || ctype_digit($arrayOfshortShortItem))) {
                $invalidValues[] = is_object($arrayOfshortShortItem) ? get_class($arrayOfshortShortItem) : sprintf('%s(%s)', gettype($arrayOfshortShortItem), var_export($arrayOfshortShortItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The short property can only contain items of type short, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set short value
     * @throws \InvalidArgumentException
     * @param int[] $short
     * @return \ArrayType\ArrayOfshort
     */
    public function setShort(array $short = array())
    {
        // validation for constraint: array
        if ('' !== ($shortArrayErrorMessage = self::validateShortForArrayConstraintsFromSetShort($short))) {
            throw new \InvalidArgumentException($shortArrayErrorMessage, __LINE__);
        }
        $this->short = $short;
        return $this;
    }
    /**
     * Add item to short value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \ArrayType\ArrayOfshort
     */
    public function addToShort($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The short property can only contain items of type short, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->short[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return int|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return int|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return int|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return int|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return int|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string short
     */
    public function getAttributeName()
    {
        return 'short';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfshort
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
