<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStatValue ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfStatValue
 * @subpackage Arrays
 */
class ArrayOfStatValue extends AbstractStructArrayBase
{
    /**
     * The StatValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StatValue[]
     */
    public $StatValue;
    /**
     * Constructor method for ArrayOfStatValue
     * @uses ArrayOfStatValue::setStatValue()
     * @param \StructType\StatValue[] $statValue
     */
    public function __construct(array $statValue = array())
    {
        $this
            ->setStatValue($statValue);
    }
    /**
     * Get StatValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StatValue[]|null
     */
    public function getStatValue()
    {
        return isset($this->StatValue) ? $this->StatValue : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStatValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatValueForArrayConstraintsFromSetStatValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfStatValueStatValueItem) {
            // validation for constraint: itemType
            if (!$arrayOfStatValueStatValueItem instanceof \StructType\StatValue) {
                $invalidValues[] = is_object($arrayOfStatValueStatValueItem) ? get_class($arrayOfStatValueStatValueItem) : sprintf('%s(%s)', gettype($arrayOfStatValueStatValueItem), var_export($arrayOfStatValueStatValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StatValue property can only contain items of type \StructType\StatValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StatValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StatValue[] $statValue
     * @return \ArrayType\ArrayOfStatValue
     */
    public function setStatValue(array $statValue = array())
    {
        // validation for constraint: array
        if ('' !== ($statValueArrayErrorMessage = self::validateStatValueForArrayConstraintsFromSetStatValue($statValue))) {
            throw new \InvalidArgumentException($statValueArrayErrorMessage, __LINE__);
        }
        if (is_null($statValue) || (is_array($statValue) && empty($statValue))) {
            unset($this->StatValue);
        } else {
            $this->StatValue = $statValue;
        }
        return $this;
    }
    /**
     * Add item to StatValue value
     * @throws \InvalidArgumentException
     * @param \StructType\StatValue $item
     * @return \ArrayType\ArrayOfStatValue
     */
    public function addToStatValue(\StructType\StatValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StatValue) {
            throw new \InvalidArgumentException(sprintf('The StatValue property can only contain items of type \StructType\StatValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StatValue[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\StatValue|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\StatValue|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\StatValue|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\StatValue|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\StatValue|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string StatValue
     */
    public function getAttributeName()
    {
        return 'StatValue';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfStatValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
