<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypeTour StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TypeTour
 * @subpackage Structs
 */
class TypeTour extends DictionaryBase
{
    /**
     * The HasTours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasTours;
    /**
     * The ParentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParentID;
    /**
     * Constructor method for TypeTour
     * @uses TypeTour::setHasTours()
     * @uses TypeTour::setParentID()
     * @param bool $hasTours
     * @param int $parentID
     */
    public function __construct($hasTours = null, $parentID = null)
    {
        $this
            ->setHasTours($hasTours)
            ->setParentID($parentID);
    }
    /**
     * Get HasTours value
     * @return bool|null
     */
    public function getHasTours()
    {
        return $this->HasTours;
    }
    /**
     * Set HasTours value
     * @param bool $hasTours
     * @return \StructType\TypeTour
     */
    public function setHasTours($hasTours = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasTours) && !is_bool($hasTours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasTours, true), gettype($hasTours)), __LINE__);
        }
        $this->HasTours = $hasTours;
        return $this;
    }
    /**
     * Get ParentID value
     * @return int|null
     */
    public function getParentID()
    {
        return $this->ParentID;
    }
    /**
     * Set ParentID value
     * @param int $parentID
     * @return \StructType\TypeTour
     */
    public function setParentID($parentID = null)
    {
        // validation for constraint: int
        if (!is_null($parentID) && !(is_int($parentID) || ctype_digit($parentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentID, true), gettype($parentID)), __LINE__);
        }
        $this->ParentID = $parentID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TypeTour
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
