<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TourPriceEx StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TourPriceEx
 * @subpackage Structs
 */
class TourPriceEx extends AbstractStructBase
{
    /**
     * The BasketLink
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BasketLink;
    /**
     * The CityToKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CityToKey;
    /**
     * The CityToName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CityToName;
    /**
     * The DateBegin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateBegin;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Duration;
    /**
     * The Extension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Extension;
    /**
     * The FlightInfos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfFlightInfo
     */
    public $FlightInfos;
    /**
     * The GdsFlightPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $GdsFlightPrice;
    /**
     * The HasTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasTickets;
    /**
     * The HotLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HotLevel;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The IncludedServices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncludedServices;
    /**
     * The MainHotelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MainHotelId;
    /**
     * The MainHotelOfferVariants
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HotelOfferVariants
     */
    public $MainHotelOfferVariants;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Price;
    /**
     * The PricePrevious
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PricePrevious;
    /**
     * The QuotaState_FlightArrival
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QuotaState_FlightArrival;
    /**
     * The QuotaState_FlightArrival_B
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QuotaState_FlightArrival_B;
    /**
     * The QuotaState_FlightDeparture
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QuotaState_FlightDeparture;
    /**
     * The QuotaState_FlightDeparture_B
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QuotaState_FlightDeparture_B;
    /**
     * The QuotaState_Hotel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QuotaState_Hotel;
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Rate;
    /**
     * The TRID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TRID;
    /**
     * The TourID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TourID;
    /**
     * The TourName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TourName;
    /**
     * The TourPriceServiceInfos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTourPriceServiceInfo
     */
    public $TourPriceServiceInfos;
    /**
     * The TourTypeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TourTypeID;
    /**
     * The TourTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TourTypeName;
    /**
     * The TourUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TourUrl;
    /**
     * The TransportTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransportTypeId;
    /**
     * Constructor method for TourPriceEx
     * @uses TourPriceEx::setBasketLink()
     * @uses TourPriceEx::setCityToKey()
     * @uses TourPriceEx::setCityToName()
     * @uses TourPriceEx::setDateBegin()
     * @uses TourPriceEx::setDuration()
     * @uses TourPriceEx::setExtension()
     * @uses TourPriceEx::setFlightInfos()
     * @uses TourPriceEx::setGdsFlightPrice()
     * @uses TourPriceEx::setHasTickets()
     * @uses TourPriceEx::setHotLevel()
     * @uses TourPriceEx::setID()
     * @uses TourPriceEx::setIncludedServices()
     * @uses TourPriceEx::setMainHotelId()
     * @uses TourPriceEx::setMainHotelOfferVariants()
     * @uses TourPriceEx::setPrice()
     * @uses TourPriceEx::setPricePrevious()
     * @uses TourPriceEx::setQuotaState_FlightArrival()
     * @uses TourPriceEx::setQuotaState_FlightArrival_B()
     * @uses TourPriceEx::setQuotaState_FlightDeparture()
     * @uses TourPriceEx::setQuotaState_FlightDeparture_B()
     * @uses TourPriceEx::setQuotaState_Hotel()
     * @uses TourPriceEx::setRate()
     * @uses TourPriceEx::setTRID()
     * @uses TourPriceEx::setTourID()
     * @uses TourPriceEx::setTourName()
     * @uses TourPriceEx::setTourPriceServiceInfos()
     * @uses TourPriceEx::setTourTypeID()
     * @uses TourPriceEx::setTourTypeName()
     * @uses TourPriceEx::setTourUrl()
     * @uses TourPriceEx::setTransportTypeId()
     * @param string $basketLink
     * @param int $cityToKey
     * @param string $cityToName
     * @param string $dateBegin
     * @param int $duration
     * @param string $extension
     * @param \ArrayType\ArrayOfFlightInfo $flightInfos
     * @param float $gdsFlightPrice
     * @param bool $hasTickets
     * @param int $hotLevel
     * @param int $iD
     * @param string $includedServices
     * @param int $mainHotelId
     * @param \StructType\HotelOfferVariants $mainHotelOfferVariants
     * @param float $price
     * @param float $pricePrevious
     * @param string $quotaState_FlightArrival
     * @param string $quotaState_FlightArrival_B
     * @param string $quotaState_FlightDeparture
     * @param string $quotaState_FlightDeparture_B
     * @param string $quotaState_Hotel
     * @param string $rate
     * @param int $tRID
     * @param int $tourID
     * @param string $tourName
     * @param \ArrayType\ArrayOfTourPriceServiceInfo $tourPriceServiceInfos
     * @param int $tourTypeID
     * @param string $tourTypeName
     * @param string $tourUrl
     * @param int $transportTypeId
     */
    public function __construct($basketLink = null, $cityToKey = null, $cityToName = null, $dateBegin = null, $duration = null, $extension = null, \ArrayType\ArrayOfFlightInfo $flightInfos = null, $gdsFlightPrice = null, $hasTickets = null, $hotLevel = null, $iD = null, $includedServices = null, $mainHotelId = null, \StructType\HotelOfferVariants $mainHotelOfferVariants = null, $price = null, $pricePrevious = null, $quotaState_FlightArrival = null, $quotaState_FlightArrival_B = null, $quotaState_FlightDeparture = null, $quotaState_FlightDeparture_B = null, $quotaState_Hotel = null, $rate = null, $tRID = null, $tourID = null, $tourName = null, \ArrayType\ArrayOfTourPriceServiceInfo $tourPriceServiceInfos = null, $tourTypeID = null, $tourTypeName = null, $tourUrl = null, $transportTypeId = null)
    {
        $this
            ->setBasketLink($basketLink)
            ->setCityToKey($cityToKey)
            ->setCityToName($cityToName)
            ->setDateBegin($dateBegin)
            ->setDuration($duration)
            ->setExtension($extension)
            ->setFlightInfos($flightInfos)
            ->setGdsFlightPrice($gdsFlightPrice)
            ->setHasTickets($hasTickets)
            ->setHotLevel($hotLevel)
            ->setID($iD)
            ->setIncludedServices($includedServices)
            ->setMainHotelId($mainHotelId)
            ->setMainHotelOfferVariants($mainHotelOfferVariants)
            ->setPrice($price)
            ->setPricePrevious($pricePrevious)
            ->setQuotaState_FlightArrival($quotaState_FlightArrival)
            ->setQuotaState_FlightArrival_B($quotaState_FlightArrival_B)
            ->setQuotaState_FlightDeparture($quotaState_FlightDeparture)
            ->setQuotaState_FlightDeparture_B($quotaState_FlightDeparture_B)
            ->setQuotaState_Hotel($quotaState_Hotel)
            ->setRate($rate)
            ->setTRID($tRID)
            ->setTourID($tourID)
            ->setTourName($tourName)
            ->setTourPriceServiceInfos($tourPriceServiceInfos)
            ->setTourTypeID($tourTypeID)
            ->setTourTypeName($tourTypeName)
            ->setTourUrl($tourUrl)
            ->setTransportTypeId($transportTypeId);
    }
    /**
     * Get BasketLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBasketLink()
    {
        return isset($this->BasketLink) ? $this->BasketLink : null;
    }
    /**
     * Set BasketLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $basketLink
     * @return \StructType\TourPriceEx
     */
    public function setBasketLink($basketLink = null)
    {
        // validation for constraint: string
        if (!is_null($basketLink) && !is_string($basketLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($basketLink, true), gettype($basketLink)), __LINE__);
        }
        if (is_null($basketLink) || (is_array($basketLink) && empty($basketLink))) {
            unset($this->BasketLink);
        } else {
            $this->BasketLink = $basketLink;
        }
        return $this;
    }
    /**
     * Get CityToKey value
     * @return int|null
     */
    public function getCityToKey()
    {
        return $this->CityToKey;
    }
    /**
     * Set CityToKey value
     * @param int $cityToKey
     * @return \StructType\TourPriceEx
     */
    public function setCityToKey($cityToKey = null)
    {
        // validation for constraint: int
        if (!is_null($cityToKey) && !(is_int($cityToKey) || ctype_digit($cityToKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cityToKey, true), gettype($cityToKey)), __LINE__);
        }
        $this->CityToKey = $cityToKey;
        return $this;
    }
    /**
     * Get CityToName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCityToName()
    {
        return isset($this->CityToName) ? $this->CityToName : null;
    }
    /**
     * Set CityToName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cityToName
     * @return \StructType\TourPriceEx
     */
    public function setCityToName($cityToName = null)
    {
        // validation for constraint: string
        if (!is_null($cityToName) && !is_string($cityToName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityToName, true), gettype($cityToName)), __LINE__);
        }
        if (is_null($cityToName) || (is_array($cityToName) && empty($cityToName))) {
            unset($this->CityToName);
        } else {
            $this->CityToName = $cityToName;
        }
        return $this;
    }
    /**
     * Get DateBegin value
     * @return string|null
     */
    public function getDateBegin()
    {
        return $this->DateBegin;
    }
    /**
     * Set DateBegin value
     * @param string $dateBegin
     * @return \StructType\TourPriceEx
     */
    public function setDateBegin($dateBegin = null)
    {
        // validation for constraint: string
        if (!is_null($dateBegin) && !is_string($dateBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateBegin, true), gettype($dateBegin)), __LINE__);
        }
        $this->DateBegin = $dateBegin;
        return $this;
    }
    /**
     * Get Duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \StructType\TourPriceEx
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get Extension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtension()
    {
        return isset($this->Extension) ? $this->Extension : null;
    }
    /**
     * Set Extension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extension
     * @return \StructType\TourPriceEx
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extension, true), gettype($extension)), __LINE__);
        }
        if (is_null($extension) || (is_array($extension) && empty($extension))) {
            unset($this->Extension);
        } else {
            $this->Extension = $extension;
        }
        return $this;
    }
    /**
     * Get FlightInfos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfFlightInfo|null
     */
    public function getFlightInfos()
    {
        return isset($this->FlightInfos) ? $this->FlightInfos : null;
    }
    /**
     * Set FlightInfos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfFlightInfo $flightInfos
     * @return \StructType\TourPriceEx
     */
    public function setFlightInfos(\ArrayType\ArrayOfFlightInfo $flightInfos = null)
    {
        if (is_null($flightInfos) || (is_array($flightInfos) && empty($flightInfos))) {
            unset($this->FlightInfos);
        } else {
            $this->FlightInfos = $flightInfos;
        }
        return $this;
    }
    /**
     * Get GdsFlightPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGdsFlightPrice()
    {
        return isset($this->GdsFlightPrice) ? $this->GdsFlightPrice : null;
    }
    /**
     * Set GdsFlightPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $gdsFlightPrice
     * @return \StructType\TourPriceEx
     */
    public function setGdsFlightPrice($gdsFlightPrice = null)
    {
        // validation for constraint: float
        if (!is_null($gdsFlightPrice) && !(is_float($gdsFlightPrice) || is_numeric($gdsFlightPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gdsFlightPrice, true), gettype($gdsFlightPrice)), __LINE__);
        }
        if (is_null($gdsFlightPrice) || (is_array($gdsFlightPrice) && empty($gdsFlightPrice))) {
            unset($this->GdsFlightPrice);
        } else {
            $this->GdsFlightPrice = $gdsFlightPrice;
        }
        return $this;
    }
    /**
     * Get HasTickets value
     * @return bool|null
     */
    public function getHasTickets()
    {
        return $this->HasTickets;
    }
    /**
     * Set HasTickets value
     * @param bool $hasTickets
     * @return \StructType\TourPriceEx
     */
    public function setHasTickets($hasTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasTickets) && !is_bool($hasTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasTickets, true), gettype($hasTickets)), __LINE__);
        }
        $this->HasTickets = $hasTickets;
        return $this;
    }
    /**
     * Get HotLevel value
     * @return int|null
     */
    public function getHotLevel()
    {
        return $this->HotLevel;
    }
    /**
     * Set HotLevel value
     * @param int $hotLevel
     * @return \StructType\TourPriceEx
     */
    public function setHotLevel($hotLevel = null)
    {
        // validation for constraint: int
        if (!is_null($hotLevel) && !(is_int($hotLevel) || ctype_digit($hotLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hotLevel, true), gettype($hotLevel)), __LINE__);
        }
        $this->HotLevel = $hotLevel;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\TourPriceEx
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IncludedServices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludedServices()
    {
        return isset($this->IncludedServices) ? $this->IncludedServices : null;
    }
    /**
     * Set IncludedServices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $includedServices
     * @return \StructType\TourPriceEx
     */
    public function setIncludedServices($includedServices = null)
    {
        // validation for constraint: string
        if (!is_null($includedServices) && !is_string($includedServices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($includedServices, true), gettype($includedServices)), __LINE__);
        }
        if (is_null($includedServices) || (is_array($includedServices) && empty($includedServices))) {
            unset($this->IncludedServices);
        } else {
            $this->IncludedServices = $includedServices;
        }
        return $this;
    }
    /**
     * Get MainHotelId value
     * @return int|null
     */
    public function getMainHotelId()
    {
        return $this->MainHotelId;
    }
    /**
     * Set MainHotelId value
     * @param int $mainHotelId
     * @return \StructType\TourPriceEx
     */
    public function setMainHotelId($mainHotelId = null)
    {
        // validation for constraint: int
        if (!is_null($mainHotelId) && !(is_int($mainHotelId) || ctype_digit($mainHotelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mainHotelId, true), gettype($mainHotelId)), __LINE__);
        }
        $this->MainHotelId = $mainHotelId;
        return $this;
    }
    /**
     * Get MainHotelOfferVariants value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HotelOfferVariants|null
     */
    public function getMainHotelOfferVariants()
    {
        return isset($this->MainHotelOfferVariants) ? $this->MainHotelOfferVariants : null;
    }
    /**
     * Set MainHotelOfferVariants value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HotelOfferVariants $mainHotelOfferVariants
     * @return \StructType\TourPriceEx
     */
    public function setMainHotelOfferVariants(\StructType\HotelOfferVariants $mainHotelOfferVariants = null)
    {
        if (is_null($mainHotelOfferVariants) || (is_array($mainHotelOfferVariants) && empty($mainHotelOfferVariants))) {
            unset($this->MainHotelOfferVariants);
        } else {
            $this->MainHotelOfferVariants = $mainHotelOfferVariants;
        }
        return $this;
    }
    /**
     * Get Price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\TourPriceEx
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get PricePrevious value
     * @return float|null
     */
    public function getPricePrevious()
    {
        return $this->PricePrevious;
    }
    /**
     * Set PricePrevious value
     * @param float $pricePrevious
     * @return \StructType\TourPriceEx
     */
    public function setPricePrevious($pricePrevious = null)
    {
        // validation for constraint: float
        if (!is_null($pricePrevious) && !(is_float($pricePrevious) || is_numeric($pricePrevious))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pricePrevious, true), gettype($pricePrevious)), __LINE__);
        }
        $this->PricePrevious = $pricePrevious;
        return $this;
    }
    /**
     * Get QuotaState_FlightArrival value
     * @return string|null
     */
    public function getQuotaState_FlightArrival()
    {
        return $this->QuotaState_FlightArrival;
    }
    /**
     * Set QuotaState_FlightArrival value
     * @uses \EnumType\QuotaState::valueIsValid()
     * @uses \EnumType\QuotaState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quotaState_FlightArrival
     * @return \StructType\TourPriceEx
     */
    public function setQuotaState_FlightArrival($quotaState_FlightArrival = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QuotaState::valueIsValid($quotaState_FlightArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\QuotaState', is_array($quotaState_FlightArrival) ? implode(', ', $quotaState_FlightArrival) : var_export($quotaState_FlightArrival, true), implode(', ', \EnumType\QuotaState::getValidValues())), __LINE__);
        }
        $this->QuotaState_FlightArrival = $quotaState_FlightArrival;
        return $this;
    }
    /**
     * Get QuotaState_FlightArrival_B value
     * @return string|null
     */
    public function getQuotaState_FlightArrival_B()
    {
        return $this->QuotaState_FlightArrival_B;
    }
    /**
     * Set QuotaState_FlightArrival_B value
     * @uses \EnumType\QuotaState::valueIsValid()
     * @uses \EnumType\QuotaState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quotaState_FlightArrival_B
     * @return \StructType\TourPriceEx
     */
    public function setQuotaState_FlightArrival_B($quotaState_FlightArrival_B = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QuotaState::valueIsValid($quotaState_FlightArrival_B)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\QuotaState', is_array($quotaState_FlightArrival_B) ? implode(', ', $quotaState_FlightArrival_B) : var_export($quotaState_FlightArrival_B, true), implode(', ', \EnumType\QuotaState::getValidValues())), __LINE__);
        }
        $this->QuotaState_FlightArrival_B = $quotaState_FlightArrival_B;
        return $this;
    }
    /**
     * Get QuotaState_FlightDeparture value
     * @return string|null
     */
    public function getQuotaState_FlightDeparture()
    {
        return $this->QuotaState_FlightDeparture;
    }
    /**
     * Set QuotaState_FlightDeparture value
     * @uses \EnumType\QuotaState::valueIsValid()
     * @uses \EnumType\QuotaState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quotaState_FlightDeparture
     * @return \StructType\TourPriceEx
     */
    public function setQuotaState_FlightDeparture($quotaState_FlightDeparture = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QuotaState::valueIsValid($quotaState_FlightDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\QuotaState', is_array($quotaState_FlightDeparture) ? implode(', ', $quotaState_FlightDeparture) : var_export($quotaState_FlightDeparture, true), implode(', ', \EnumType\QuotaState::getValidValues())), __LINE__);
        }
        $this->QuotaState_FlightDeparture = $quotaState_FlightDeparture;
        return $this;
    }
    /**
     * Get QuotaState_FlightDeparture_B value
     * @return string|null
     */
    public function getQuotaState_FlightDeparture_B()
    {
        return $this->QuotaState_FlightDeparture_B;
    }
    /**
     * Set QuotaState_FlightDeparture_B value
     * @uses \EnumType\QuotaState::valueIsValid()
     * @uses \EnumType\QuotaState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quotaState_FlightDeparture_B
     * @return \StructType\TourPriceEx
     */
    public function setQuotaState_FlightDeparture_B($quotaState_FlightDeparture_B = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QuotaState::valueIsValid($quotaState_FlightDeparture_B)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\QuotaState', is_array($quotaState_FlightDeparture_B) ? implode(', ', $quotaState_FlightDeparture_B) : var_export($quotaState_FlightDeparture_B, true), implode(', ', \EnumType\QuotaState::getValidValues())), __LINE__);
        }
        $this->QuotaState_FlightDeparture_B = $quotaState_FlightDeparture_B;
        return $this;
    }
    /**
     * Get QuotaState_Hotel value
     * @return string|null
     */
    public function getQuotaState_Hotel()
    {
        return $this->QuotaState_Hotel;
    }
    /**
     * Set QuotaState_Hotel value
     * @uses \EnumType\QuotaState::valueIsValid()
     * @uses \EnumType\QuotaState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quotaState_Hotel
     * @return \StructType\TourPriceEx
     */
    public function setQuotaState_Hotel($quotaState_Hotel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QuotaState::valueIsValid($quotaState_Hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\QuotaState', is_array($quotaState_Hotel) ? implode(', ', $quotaState_Hotel) : var_export($quotaState_Hotel, true), implode(', ', \EnumType\QuotaState::getValidValues())), __LINE__);
        }
        $this->QuotaState_Hotel = $quotaState_Hotel;
        return $this;
    }
    /**
     * Get Rate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRate()
    {
        return isset($this->Rate) ? $this->Rate : null;
    }
    /**
     * Set Rate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rate
     * @return \StructType\TourPriceEx
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        if (is_null($rate) || (is_array($rate) && empty($rate))) {
            unset($this->Rate);
        } else {
            $this->Rate = $rate;
        }
        return $this;
    }
    /**
     * Get TRID value
     * @return int|null
     */
    public function getTRID()
    {
        return $this->TRID;
    }
    /**
     * Set TRID value
     * @param int $tRID
     * @return \StructType\TourPriceEx
     */
    public function setTRID($tRID = null)
    {
        // validation for constraint: int
        if (!is_null($tRID) && !(is_int($tRID) || ctype_digit($tRID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tRID, true), gettype($tRID)), __LINE__);
        }
        $this->TRID = $tRID;
        return $this;
    }
    /**
     * Get TourID value
     * @return int|null
     */
    public function getTourID()
    {
        return $this->TourID;
    }
    /**
     * Set TourID value
     * @param int $tourID
     * @return \StructType\TourPriceEx
     */
    public function setTourID($tourID = null)
    {
        // validation for constraint: int
        if (!is_null($tourID) && !(is_int($tourID) || ctype_digit($tourID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tourID, true), gettype($tourID)), __LINE__);
        }
        $this->TourID = $tourID;
        return $this;
    }
    /**
     * Get TourName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTourName()
    {
        return isset($this->TourName) ? $this->TourName : null;
    }
    /**
     * Set TourName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tourName
     * @return \StructType\TourPriceEx
     */
    public function setTourName($tourName = null)
    {
        // validation for constraint: string
        if (!is_null($tourName) && !is_string($tourName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourName, true), gettype($tourName)), __LINE__);
        }
        if (is_null($tourName) || (is_array($tourName) && empty($tourName))) {
            unset($this->TourName);
        } else {
            $this->TourName = $tourName;
        }
        return $this;
    }
    /**
     * Get TourPriceServiceInfos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTourPriceServiceInfo|null
     */
    public function getTourPriceServiceInfos()
    {
        return isset($this->TourPriceServiceInfos) ? $this->TourPriceServiceInfos : null;
    }
    /**
     * Set TourPriceServiceInfos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTourPriceServiceInfo $tourPriceServiceInfos
     * @return \StructType\TourPriceEx
     */
    public function setTourPriceServiceInfos(\ArrayType\ArrayOfTourPriceServiceInfo $tourPriceServiceInfos = null)
    {
        if (is_null($tourPriceServiceInfos) || (is_array($tourPriceServiceInfos) && empty($tourPriceServiceInfos))) {
            unset($this->TourPriceServiceInfos);
        } else {
            $this->TourPriceServiceInfos = $tourPriceServiceInfos;
        }
        return $this;
    }
    /**
     * Get TourTypeID value
     * @return int|null
     */
    public function getTourTypeID()
    {
        return $this->TourTypeID;
    }
    /**
     * Set TourTypeID value
     * @param int $tourTypeID
     * @return \StructType\TourPriceEx
     */
    public function setTourTypeID($tourTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($tourTypeID) && !(is_int($tourTypeID) || ctype_digit($tourTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tourTypeID, true), gettype($tourTypeID)), __LINE__);
        }
        $this->TourTypeID = $tourTypeID;
        return $this;
    }
    /**
     * Get TourTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTourTypeName()
    {
        return isset($this->TourTypeName) ? $this->TourTypeName : null;
    }
    /**
     * Set TourTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tourTypeName
     * @return \StructType\TourPriceEx
     */
    public function setTourTypeName($tourTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($tourTypeName) && !is_string($tourTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourTypeName, true), gettype($tourTypeName)), __LINE__);
        }
        if (is_null($tourTypeName) || (is_array($tourTypeName) && empty($tourTypeName))) {
            unset($this->TourTypeName);
        } else {
            $this->TourTypeName = $tourTypeName;
        }
        return $this;
    }
    /**
     * Get TourUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTourUrl()
    {
        return isset($this->TourUrl) ? $this->TourUrl : null;
    }
    /**
     * Set TourUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tourUrl
     * @return \StructType\TourPriceEx
     */
    public function setTourUrl($tourUrl = null)
    {
        // validation for constraint: string
        if (!is_null($tourUrl) && !is_string($tourUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourUrl, true), gettype($tourUrl)), __LINE__);
        }
        if (is_null($tourUrl) || (is_array($tourUrl) && empty($tourUrl))) {
            unset($this->TourUrl);
        } else {
            $this->TourUrl = $tourUrl;
        }
        return $this;
    }
    /**
     * Get TransportTypeId value
     * @return int|null
     */
    public function getTransportTypeId()
    {
        return $this->TransportTypeId;
    }
    /**
     * Set TransportTypeId value
     * @param int $transportTypeId
     * @return \StructType\TourPriceEx
     */
    public function setTransportTypeId($transportTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($transportTypeId) && !(is_int($transportTypeId) || ctype_digit($transportTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transportTypeId, true), gettype($transportTypeId)), __LINE__);
        }
        $this->TransportTypeId = $transportTypeId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TourPriceEx
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
