<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TourHotelVariant StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TourHotelVariant
 * @subpackage Structs
 */
class TourHotelVariant extends AbstractStructBase
{
    /**
     * The Meal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Meal;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Price;
    /**
     * The QuotaState_FlightArrival
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QuotaState_FlightArrival;
    /**
     * The QuotaState_FlightArrival_B
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QuotaState_FlightArrival_B;
    /**
     * The QuotaState_FlightDeparture
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QuotaState_FlightDeparture;
    /**
     * The QuotaState_FlightDeparture_B
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QuotaState_FlightDeparture_B;
    /**
     * The QuotaState_Hotel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QuotaState_Hotel;
    /**
     * The RoomCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoomCategory;
    /**
     * The RoomType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoomType;
    /**
     * The TourPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TourPriceEx
     */
    public $TourPrice;
    /**
     * Constructor method for TourHotelVariant
     * @uses TourHotelVariant::setMeal()
     * @uses TourHotelVariant::setPrice()
     * @uses TourHotelVariant::setQuotaState_FlightArrival()
     * @uses TourHotelVariant::setQuotaState_FlightArrival_B()
     * @uses TourHotelVariant::setQuotaState_FlightDeparture()
     * @uses TourHotelVariant::setQuotaState_FlightDeparture_B()
     * @uses TourHotelVariant::setQuotaState_Hotel()
     * @uses TourHotelVariant::setRoomCategory()
     * @uses TourHotelVariant::setRoomType()
     * @uses TourHotelVariant::setTourPrice()
     * @param string $meal
     * @param float $price
     * @param string $quotaState_FlightArrival
     * @param string $quotaState_FlightArrival_B
     * @param string $quotaState_FlightDeparture
     * @param string $quotaState_FlightDeparture_B
     * @param string $quotaState_Hotel
     * @param string $roomCategory
     * @param string $roomType
     * @param \StructType\TourPriceEx $tourPrice
     */
    public function __construct($meal = null, $price = null, $quotaState_FlightArrival = null, $quotaState_FlightArrival_B = null, $quotaState_FlightDeparture = null, $quotaState_FlightDeparture_B = null, $quotaState_Hotel = null, $roomCategory = null, $roomType = null, \StructType\TourPriceEx $tourPrice = null)
    {
        $this
            ->setMeal($meal)
            ->setPrice($price)
            ->setQuotaState_FlightArrival($quotaState_FlightArrival)
            ->setQuotaState_FlightArrival_B($quotaState_FlightArrival_B)
            ->setQuotaState_FlightDeparture($quotaState_FlightDeparture)
            ->setQuotaState_FlightDeparture_B($quotaState_FlightDeparture_B)
            ->setQuotaState_Hotel($quotaState_Hotel)
            ->setRoomCategory($roomCategory)
            ->setRoomType($roomType)
            ->setTourPrice($tourPrice);
    }
    /**
     * Get Meal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMeal()
    {
        return isset($this->Meal) ? $this->Meal : null;
    }
    /**
     * Set Meal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $meal
     * @return \StructType\TourHotelVariant
     */
    public function setMeal($meal = null)
    {
        // validation for constraint: string
        if (!is_null($meal) && !is_string($meal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meal, true), gettype($meal)), __LINE__);
        }
        if (is_null($meal) || (is_array($meal) && empty($meal))) {
            unset($this->Meal);
        } else {
            $this->Meal = $meal;
        }
        return $this;
    }
    /**
     * Get Price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\TourHotelVariant
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get QuotaState_FlightArrival value
     * @return string|null
     */
    public function getQuotaState_FlightArrival()
    {
        return $this->QuotaState_FlightArrival;
    }
    /**
     * Set QuotaState_FlightArrival value
     * @uses \EnumType\QuotaState::valueIsValid()
     * @uses \EnumType\QuotaState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quotaState_FlightArrival
     * @return \StructType\TourHotelVariant
     */
    public function setQuotaState_FlightArrival($quotaState_FlightArrival = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QuotaState::valueIsValid($quotaState_FlightArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\QuotaState', is_array($quotaState_FlightArrival) ? implode(', ', $quotaState_FlightArrival) : var_export($quotaState_FlightArrival, true), implode(', ', \EnumType\QuotaState::getValidValues())), __LINE__);
        }
        $this->QuotaState_FlightArrival = $quotaState_FlightArrival;
        return $this;
    }
    /**
     * Get QuotaState_FlightArrival_B value
     * @return string|null
     */
    public function getQuotaState_FlightArrival_B()
    {
        return $this->QuotaState_FlightArrival_B;
    }
    /**
     * Set QuotaState_FlightArrival_B value
     * @uses \EnumType\QuotaState::valueIsValid()
     * @uses \EnumType\QuotaState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quotaState_FlightArrival_B
     * @return \StructType\TourHotelVariant
     */
    public function setQuotaState_FlightArrival_B($quotaState_FlightArrival_B = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QuotaState::valueIsValid($quotaState_FlightArrival_B)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\QuotaState', is_array($quotaState_FlightArrival_B) ? implode(', ', $quotaState_FlightArrival_B) : var_export($quotaState_FlightArrival_B, true), implode(', ', \EnumType\QuotaState::getValidValues())), __LINE__);
        }
        $this->QuotaState_FlightArrival_B = $quotaState_FlightArrival_B;
        return $this;
    }
    /**
     * Get QuotaState_FlightDeparture value
     * @return string|null
     */
    public function getQuotaState_FlightDeparture()
    {
        return $this->QuotaState_FlightDeparture;
    }
    /**
     * Set QuotaState_FlightDeparture value
     * @uses \EnumType\QuotaState::valueIsValid()
     * @uses \EnumType\QuotaState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quotaState_FlightDeparture
     * @return \StructType\TourHotelVariant
     */
    public function setQuotaState_FlightDeparture($quotaState_FlightDeparture = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QuotaState::valueIsValid($quotaState_FlightDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\QuotaState', is_array($quotaState_FlightDeparture) ? implode(', ', $quotaState_FlightDeparture) : var_export($quotaState_FlightDeparture, true), implode(', ', \EnumType\QuotaState::getValidValues())), __LINE__);
        }
        $this->QuotaState_FlightDeparture = $quotaState_FlightDeparture;
        return $this;
    }
    /**
     * Get QuotaState_FlightDeparture_B value
     * @return string|null
     */
    public function getQuotaState_FlightDeparture_B()
    {
        return $this->QuotaState_FlightDeparture_B;
    }
    /**
     * Set QuotaState_FlightDeparture_B value
     * @uses \EnumType\QuotaState::valueIsValid()
     * @uses \EnumType\QuotaState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quotaState_FlightDeparture_B
     * @return \StructType\TourHotelVariant
     */
    public function setQuotaState_FlightDeparture_B($quotaState_FlightDeparture_B = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QuotaState::valueIsValid($quotaState_FlightDeparture_B)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\QuotaState', is_array($quotaState_FlightDeparture_B) ? implode(', ', $quotaState_FlightDeparture_B) : var_export($quotaState_FlightDeparture_B, true), implode(', ', \EnumType\QuotaState::getValidValues())), __LINE__);
        }
        $this->QuotaState_FlightDeparture_B = $quotaState_FlightDeparture_B;
        return $this;
    }
    /**
     * Get QuotaState_Hotel value
     * @return string|null
     */
    public function getQuotaState_Hotel()
    {
        return $this->QuotaState_Hotel;
    }
    /**
     * Set QuotaState_Hotel value
     * @uses \EnumType\QuotaState::valueIsValid()
     * @uses \EnumType\QuotaState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quotaState_Hotel
     * @return \StructType\TourHotelVariant
     */
    public function setQuotaState_Hotel($quotaState_Hotel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QuotaState::valueIsValid($quotaState_Hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\QuotaState', is_array($quotaState_Hotel) ? implode(', ', $quotaState_Hotel) : var_export($quotaState_Hotel, true), implode(', ', \EnumType\QuotaState::getValidValues())), __LINE__);
        }
        $this->QuotaState_Hotel = $quotaState_Hotel;
        return $this;
    }
    /**
     * Get RoomCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoomCategory()
    {
        return isset($this->RoomCategory) ? $this->RoomCategory : null;
    }
    /**
     * Set RoomCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roomCategory
     * @return \StructType\TourHotelVariant
     */
    public function setRoomCategory($roomCategory = null)
    {
        // validation for constraint: string
        if (!is_null($roomCategory) && !is_string($roomCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomCategory, true), gettype($roomCategory)), __LINE__);
        }
        if (is_null($roomCategory) || (is_array($roomCategory) && empty($roomCategory))) {
            unset($this->RoomCategory);
        } else {
            $this->RoomCategory = $roomCategory;
        }
        return $this;
    }
    /**
     * Get RoomType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoomType()
    {
        return isset($this->RoomType) ? $this->RoomType : null;
    }
    /**
     * Set RoomType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roomType
     * @return \StructType\TourHotelVariant
     */
    public function setRoomType($roomType = null)
    {
        // validation for constraint: string
        if (!is_null($roomType) && !is_string($roomType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomType, true), gettype($roomType)), __LINE__);
        }
        if (is_null($roomType) || (is_array($roomType) && empty($roomType))) {
            unset($this->RoomType);
        } else {
            $this->RoomType = $roomType;
        }
        return $this;
    }
    /**
     * Get TourPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TourPriceEx|null
     */
    public function getTourPrice()
    {
        return isset($this->TourPrice) ? $this->TourPrice : null;
    }
    /**
     * Set TourPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TourPriceEx $tourPrice
     * @return \StructType\TourHotelVariant
     */
    public function setTourPrice(\StructType\TourPriceEx $tourPrice = null)
    {
        if (is_null($tourPrice) || (is_array($tourPrice) && empty($tourPrice))) {
            unset($this->TourPrice);
        } else {
            $this->TourPrice = $tourPrice;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TourHotelVariant
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
