<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TourHotelGroup StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TourHotelGroup
 * @subpackage Structs
 */
class TourHotelGroup extends AbstractStructBase
{
    /**
     * The Hotel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Hotel
     */
    public $Hotel;
    /**
     * The HotelKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HotelKey;
    /**
     * The TourHotelVariants
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTourHotelVariant
     */
    public $TourHotelVariants;
    /**
     * The TourPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TourPriceEx
     */
    public $TourPrice;
    /**
     * Constructor method for TourHotelGroup
     * @uses TourHotelGroup::setHotel()
     * @uses TourHotelGroup::setHotelKey()
     * @uses TourHotelGroup::setTourHotelVariants()
     * @uses TourHotelGroup::setTourPrice()
     * @param \StructType\Hotel $hotel
     * @param int $hotelKey
     * @param \ArrayType\ArrayOfTourHotelVariant $tourHotelVariants
     * @param \StructType\TourPriceEx $tourPrice
     */
    public function __construct(\StructType\Hotel $hotel = null, $hotelKey = null, \ArrayType\ArrayOfTourHotelVariant $tourHotelVariants = null, \StructType\TourPriceEx $tourPrice = null)
    {
        $this
            ->setHotel($hotel)
            ->setHotelKey($hotelKey)
            ->setTourHotelVariants($tourHotelVariants)
            ->setTourPrice($tourPrice);
    }
    /**
     * Get Hotel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Hotel|null
     */
    public function getHotel()
    {
        return isset($this->Hotel) ? $this->Hotel : null;
    }
    /**
     * Set Hotel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Hotel $hotel
     * @return \StructType\TourHotelGroup
     */
    public function setHotel(\StructType\Hotel $hotel = null)
    {
        if (is_null($hotel) || (is_array($hotel) && empty($hotel))) {
            unset($this->Hotel);
        } else {
            $this->Hotel = $hotel;
        }
        return $this;
    }
    /**
     * Get HotelKey value
     * @return int|null
     */
    public function getHotelKey()
    {
        return $this->HotelKey;
    }
    /**
     * Set HotelKey value
     * @param int $hotelKey
     * @return \StructType\TourHotelGroup
     */
    public function setHotelKey($hotelKey = null)
    {
        // validation for constraint: int
        if (!is_null($hotelKey) && !(is_int($hotelKey) || ctype_digit($hotelKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hotelKey, true), gettype($hotelKey)), __LINE__);
        }
        $this->HotelKey = $hotelKey;
        return $this;
    }
    /**
     * Get TourHotelVariants value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTourHotelVariant|null
     */
    public function getTourHotelVariants()
    {
        return isset($this->TourHotelVariants) ? $this->TourHotelVariants : null;
    }
    /**
     * Set TourHotelVariants value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTourHotelVariant $tourHotelVariants
     * @return \StructType\TourHotelGroup
     */
    public function setTourHotelVariants(\ArrayType\ArrayOfTourHotelVariant $tourHotelVariants = null)
    {
        if (is_null($tourHotelVariants) || (is_array($tourHotelVariants) && empty($tourHotelVariants))) {
            unset($this->TourHotelVariants);
        } else {
            $this->TourHotelVariants = $tourHotelVariants;
        }
        return $this;
    }
    /**
     * Get TourPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TourPriceEx|null
     */
    public function getTourPrice()
    {
        return isset($this->TourPrice) ? $this->TourPrice : null;
    }
    /**
     * Set TourPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TourPriceEx $tourPrice
     * @return \StructType\TourHotelGroup
     */
    public function setTourPrice(\StructType\TourPriceEx $tourPrice = null)
    {
        if (is_null($tourPrice) || (is_array($tourPrice) && empty($tourPrice))) {
            unset($this->TourPrice);
        } else {
            $this->TourPrice = $tourPrice;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TourHotelGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
