<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SearchResult
 * @subpackage Structs
 */
class SearchResult extends AbstractStructBase
{
    /**
     * The HasMore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasMore;
    /**
     * The IsTimeout
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsTimeout;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTourPriceEx
     */
    public $Prices;
    /**
     * Constructor method for SearchResult
     * @uses SearchResult::setHasMore()
     * @uses SearchResult::setIsTimeout()
     * @uses SearchResult::setPrices()
     * @param bool $hasMore
     * @param bool $isTimeout
     * @param \ArrayType\ArrayOfTourPriceEx $prices
     */
    public function __construct($hasMore = null, $isTimeout = null, \ArrayType\ArrayOfTourPriceEx $prices = null)
    {
        $this
            ->setHasMore($hasMore)
            ->setIsTimeout($isTimeout)
            ->setPrices($prices);
    }
    /**
     * Get HasMore value
     * @return bool|null
     */
    public function getHasMore()
    {
        return $this->HasMore;
    }
    /**
     * Set HasMore value
     * @param bool $hasMore
     * @return \StructType\SearchResult
     */
    public function setHasMore($hasMore = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMore) && !is_bool($hasMore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasMore, true), gettype($hasMore)), __LINE__);
        }
        $this->HasMore = $hasMore;
        return $this;
    }
    /**
     * Get IsTimeout value
     * @return bool|null
     */
    public function getIsTimeout()
    {
        return $this->IsTimeout;
    }
    /**
     * Set IsTimeout value
     * @param bool $isTimeout
     * @return \StructType\SearchResult
     */
    public function setIsTimeout($isTimeout = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTimeout) && !is_bool($isTimeout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTimeout, true), gettype($isTimeout)), __LINE__);
        }
        $this->IsTimeout = $isTimeout;
        return $this;
    }
    /**
     * Get Prices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTourPriceEx|null
     */
    public function getPrices()
    {
        return isset($this->Prices) ? $this->Prices : null;
    }
    /**
     * Set Prices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTourPriceEx $prices
     * @return \StructType\SearchResult
     */
    public function setPrices(\ArrayType\ArrayOfTourPriceEx $prices = null)
    {
        if (is_null($prices) || (is_array($prices) && empty($prices))) {
            unset($this->Prices);
        } else {
            $this->Prices = $prices;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
