<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RoomType
 * @subpackage Structs
 */
class RoomType extends DictionaryBase
{
    /**
     * The Places
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Places;
    /**
     * The PlacesEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PlacesEx;
    /**
     * Constructor method for RoomType
     * @uses RoomType::setPlaces()
     * @uses RoomType::setPlacesEx()
     * @param int $places
     * @param int $placesEx
     */
    public function __construct($places = null, $placesEx = null)
    {
        $this
            ->setPlaces($places)
            ->setPlacesEx($placesEx);
    }
    /**
     * Get Places value
     * @return int|null
     */
    public function getPlaces()
    {
        return $this->Places;
    }
    /**
     * Set Places value
     * @param int $places
     * @return \StructType\RoomType
     */
    public function setPlaces($places = null)
    {
        // validation for constraint: int
        if (!is_null($places) && !(is_int($places) || ctype_digit($places))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($places, true), gettype($places)), __LINE__);
        }
        $this->Places = $places;
        return $this;
    }
    /**
     * Get PlacesEx value
     * @return int|null
     */
    public function getPlacesEx()
    {
        return $this->PlacesEx;
    }
    /**
     * Set PlacesEx value
     * @param int $placesEx
     * @return \StructType\RoomType
     */
    public function setPlacesEx($placesEx = null)
    {
        // validation for constraint: int
        if (!is_null($placesEx) && !(is_int($placesEx) || ctype_digit($placesEx))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($placesEx, true), gettype($placesEx)), __LINE__);
        }
        $this->PlacesEx = $placesEx;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
