<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuotaHotelItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QuotaHotelItem
 * @subpackage Structs
 */
class QuotaHotelItem extends AbstractStructBase
{
    /**
     * The Hotel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Hotel
     */
    public $Hotel;
    /**
     * The IsGroupResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsGroupResult;
    /**
     * The QuotaHotelRoomVariants
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfQuotaHotelRoomVariant
     */
    public $QuotaHotelRoomVariants;
    /**
     * Constructor method for QuotaHotelItem
     * @uses QuotaHotelItem::setHotel()
     * @uses QuotaHotelItem::setIsGroupResult()
     * @uses QuotaHotelItem::setQuotaHotelRoomVariants()
     * @param \StructType\Hotel $hotel
     * @param bool $isGroupResult
     * @param \ArrayType\ArrayOfQuotaHotelRoomVariant $quotaHotelRoomVariants
     */
    public function __construct(\StructType\Hotel $hotel = null, $isGroupResult = null, \ArrayType\ArrayOfQuotaHotelRoomVariant $quotaHotelRoomVariants = null)
    {
        $this
            ->setHotel($hotel)
            ->setIsGroupResult($isGroupResult)
            ->setQuotaHotelRoomVariants($quotaHotelRoomVariants);
    }
    /**
     * Get Hotel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Hotel|null
     */
    public function getHotel()
    {
        return isset($this->Hotel) ? $this->Hotel : null;
    }
    /**
     * Set Hotel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Hotel $hotel
     * @return \StructType\QuotaHotelItem
     */
    public function setHotel(\StructType\Hotel $hotel = null)
    {
        if (is_null($hotel) || (is_array($hotel) && empty($hotel))) {
            unset($this->Hotel);
        } else {
            $this->Hotel = $hotel;
        }
        return $this;
    }
    /**
     * Get IsGroupResult value
     * @return bool|null
     */
    public function getIsGroupResult()
    {
        return $this->IsGroupResult;
    }
    /**
     * Set IsGroupResult value
     * @param bool $isGroupResult
     * @return \StructType\QuotaHotelItem
     */
    public function setIsGroupResult($isGroupResult = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGroupResult) && !is_bool($isGroupResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGroupResult, true), gettype($isGroupResult)), __LINE__);
        }
        $this->IsGroupResult = $isGroupResult;
        return $this;
    }
    /**
     * Get QuotaHotelRoomVariants value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfQuotaHotelRoomVariant|null
     */
    public function getQuotaHotelRoomVariants()
    {
        return isset($this->QuotaHotelRoomVariants) ? $this->QuotaHotelRoomVariants : null;
    }
    /**
     * Set QuotaHotelRoomVariants value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfQuotaHotelRoomVariant $quotaHotelRoomVariants
     * @return \StructType\QuotaHotelItem
     */
    public function setQuotaHotelRoomVariants(\ArrayType\ArrayOfQuotaHotelRoomVariant $quotaHotelRoomVariants = null)
    {
        if (is_null($quotaHotelRoomVariants) || (is_array($quotaHotelRoomVariants) && empty($quotaHotelRoomVariants))) {
            unset($this->QuotaHotelRoomVariants);
        } else {
            $this->QuotaHotelRoomVariants = $quotaHotelRoomVariants;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QuotaHotelItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
