<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuotaFlightTariffs StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QuotaFlightTariffs
 * @subpackage Structs
 */
class QuotaFlightTariffs extends AbstractStructBase
{
    /**
     * The QuotaFlightTariffStates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfQuotaFlightTariffState
     */
    public $QuotaFlightTariffStates;
    /**
     * The Tariff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tariff;
    /**
     * The TariffId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TariffId;
    /**
     * The TariffName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TariffName;
    /**
     * Constructor method for QuotaFlightTariffs
     * @uses QuotaFlightTariffs::setQuotaFlightTariffStates()
     * @uses QuotaFlightTariffs::setTariff()
     * @uses QuotaFlightTariffs::setTariffId()
     * @uses QuotaFlightTariffs::setTariffName()
     * @param \ArrayType\ArrayOfQuotaFlightTariffState $quotaFlightTariffStates
     * @param string $tariff
     * @param int $tariffId
     * @param string $tariffName
     */
    public function __construct(\ArrayType\ArrayOfQuotaFlightTariffState $quotaFlightTariffStates = null, $tariff = null, $tariffId = null, $tariffName = null)
    {
        $this
            ->setQuotaFlightTariffStates($quotaFlightTariffStates)
            ->setTariff($tariff)
            ->setTariffId($tariffId)
            ->setTariffName($tariffName);
    }
    /**
     * Get QuotaFlightTariffStates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfQuotaFlightTariffState|null
     */
    public function getQuotaFlightTariffStates()
    {
        return isset($this->QuotaFlightTariffStates) ? $this->QuotaFlightTariffStates : null;
    }
    /**
     * Set QuotaFlightTariffStates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfQuotaFlightTariffState $quotaFlightTariffStates
     * @return \StructType\QuotaFlightTariffs
     */
    public function setQuotaFlightTariffStates(\ArrayType\ArrayOfQuotaFlightTariffState $quotaFlightTariffStates = null)
    {
        if (is_null($quotaFlightTariffStates) || (is_array($quotaFlightTariffStates) && empty($quotaFlightTariffStates))) {
            unset($this->QuotaFlightTariffStates);
        } else {
            $this->QuotaFlightTariffStates = $quotaFlightTariffStates;
        }
        return $this;
    }
    /**
     * Get Tariff value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTariff()
    {
        return isset($this->Tariff) ? $this->Tariff : null;
    }
    /**
     * Set Tariff value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tariff
     * @return \StructType\QuotaFlightTariffs
     */
    public function setTariff($tariff = null)
    {
        // validation for constraint: string
        if (!is_null($tariff) && !is_string($tariff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariff, true), gettype($tariff)), __LINE__);
        }
        if (is_null($tariff) || (is_array($tariff) && empty($tariff))) {
            unset($this->Tariff);
        } else {
            $this->Tariff = $tariff;
        }
        return $this;
    }
    /**
     * Get TariffId value
     * @return int|null
     */
    public function getTariffId()
    {
        return $this->TariffId;
    }
    /**
     * Set TariffId value
     * @param int $tariffId
     * @return \StructType\QuotaFlightTariffs
     */
    public function setTariffId($tariffId = null)
    {
        // validation for constraint: int
        if (!is_null($tariffId) && !(is_int($tariffId) || ctype_digit($tariffId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tariffId, true), gettype($tariffId)), __LINE__);
        }
        $this->TariffId = $tariffId;
        return $this;
    }
    /**
     * Get TariffName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTariffName()
    {
        return isset($this->TariffName) ? $this->TariffName : null;
    }
    /**
     * Set TariffName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tariffName
     * @return \StructType\QuotaFlightTariffs
     */
    public function setTariffName($tariffName = null)
    {
        // validation for constraint: string
        if (!is_null($tariffName) && !is_string($tariffName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffName, true), gettype($tariffName)), __LINE__);
        }
        if (is_null($tariffName) || (is_array($tariffName) && empty($tariffName))) {
            unset($this->TariffName);
        } else {
            $this->TariffName = $tariffName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QuotaFlightTariffs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
