<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuotaFlightItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QuotaFlightItem
 * @subpackage Structs
 */
class QuotaFlightItem extends AbstractStructBase
{
    /**
     * The AircraftName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AircraftName;
    /**
     * The Airports
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Airports;
    /**
     * The CharterId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CharterId;
    /**
     * The CharterName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CharterName;
    /**
     * The CityFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CityFrom;
    /**
     * The CityTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CityTo;
    /**
     * The QuotaFlightTariffs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfQuotaFlightTariffs
     */
    public $QuotaFlightTariffs;
    /**
     * Constructor method for QuotaFlightItem
     * @uses QuotaFlightItem::setAircraftName()
     * @uses QuotaFlightItem::setAirports()
     * @uses QuotaFlightItem::setCharterId()
     * @uses QuotaFlightItem::setCharterName()
     * @uses QuotaFlightItem::setCityFrom()
     * @uses QuotaFlightItem::setCityTo()
     * @uses QuotaFlightItem::setQuotaFlightTariffs()
     * @param string $aircraftName
     * @param string $airports
     * @param int $charterId
     * @param string $charterName
     * @param int $cityFrom
     * @param int $cityTo
     * @param \ArrayType\ArrayOfQuotaFlightTariffs $quotaFlightTariffs
     */
    public function __construct($aircraftName = null, $airports = null, $charterId = null, $charterName = null, $cityFrom = null, $cityTo = null, \ArrayType\ArrayOfQuotaFlightTariffs $quotaFlightTariffs = null)
    {
        $this
            ->setAircraftName($aircraftName)
            ->setAirports($airports)
            ->setCharterId($charterId)
            ->setCharterName($charterName)
            ->setCityFrom($cityFrom)
            ->setCityTo($cityTo)
            ->setQuotaFlightTariffs($quotaFlightTariffs);
    }
    /**
     * Get AircraftName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAircraftName()
    {
        return isset($this->AircraftName) ? $this->AircraftName : null;
    }
    /**
     * Set AircraftName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aircraftName
     * @return \StructType\QuotaFlightItem
     */
    public function setAircraftName($aircraftName = null)
    {
        // validation for constraint: string
        if (!is_null($aircraftName) && !is_string($aircraftName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aircraftName, true), gettype($aircraftName)), __LINE__);
        }
        if (is_null($aircraftName) || (is_array($aircraftName) && empty($aircraftName))) {
            unset($this->AircraftName);
        } else {
            $this->AircraftName = $aircraftName;
        }
        return $this;
    }
    /**
     * Get Airports value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAirports()
    {
        return isset($this->Airports) ? $this->Airports : null;
    }
    /**
     * Set Airports value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $airports
     * @return \StructType\QuotaFlightItem
     */
    public function setAirports($airports = null)
    {
        // validation for constraint: string
        if (!is_null($airports) && !is_string($airports)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airports, true), gettype($airports)), __LINE__);
        }
        if (is_null($airports) || (is_array($airports) && empty($airports))) {
            unset($this->Airports);
        } else {
            $this->Airports = $airports;
        }
        return $this;
    }
    /**
     * Get CharterId value
     * @return int|null
     */
    public function getCharterId()
    {
        return $this->CharterId;
    }
    /**
     * Set CharterId value
     * @param int $charterId
     * @return \StructType\QuotaFlightItem
     */
    public function setCharterId($charterId = null)
    {
        // validation for constraint: int
        if (!is_null($charterId) && !(is_int($charterId) || ctype_digit($charterId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($charterId, true), gettype($charterId)), __LINE__);
        }
        $this->CharterId = $charterId;
        return $this;
    }
    /**
     * Get CharterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCharterName()
    {
        return isset($this->CharterName) ? $this->CharterName : null;
    }
    /**
     * Set CharterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $charterName
     * @return \StructType\QuotaFlightItem
     */
    public function setCharterName($charterName = null)
    {
        // validation for constraint: string
        if (!is_null($charterName) && !is_string($charterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($charterName, true), gettype($charterName)), __LINE__);
        }
        if (is_null($charterName) || (is_array($charterName) && empty($charterName))) {
            unset($this->CharterName);
        } else {
            $this->CharterName = $charterName;
        }
        return $this;
    }
    /**
     * Get CityFrom value
     * @return int|null
     */
    public function getCityFrom()
    {
        return $this->CityFrom;
    }
    /**
     * Set CityFrom value
     * @param int $cityFrom
     * @return \StructType\QuotaFlightItem
     */
    public function setCityFrom($cityFrom = null)
    {
        // validation for constraint: int
        if (!is_null($cityFrom) && !(is_int($cityFrom) || ctype_digit($cityFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cityFrom, true), gettype($cityFrom)), __LINE__);
        }
        $this->CityFrom = $cityFrom;
        return $this;
    }
    /**
     * Get CityTo value
     * @return int|null
     */
    public function getCityTo()
    {
        return $this->CityTo;
    }
    /**
     * Set CityTo value
     * @param int $cityTo
     * @return \StructType\QuotaFlightItem
     */
    public function setCityTo($cityTo = null)
    {
        // validation for constraint: int
        if (!is_null($cityTo) && !(is_int($cityTo) || ctype_digit($cityTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cityTo, true), gettype($cityTo)), __LINE__);
        }
        $this->CityTo = $cityTo;
        return $this;
    }
    /**
     * Get QuotaFlightTariffs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfQuotaFlightTariffs|null
     */
    public function getQuotaFlightTariffs()
    {
        return isset($this->QuotaFlightTariffs) ? $this->QuotaFlightTariffs : null;
    }
    /**
     * Set QuotaFlightTariffs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfQuotaFlightTariffs $quotaFlightTariffs
     * @return \StructType\QuotaFlightItem
     */
    public function setQuotaFlightTariffs(\ArrayType\ArrayOfQuotaFlightTariffs $quotaFlightTariffs = null)
    {
        if (is_null($quotaFlightTariffs) || (is_array($quotaFlightTariffs) && empty($quotaFlightTariffs))) {
            unset($this->QuotaFlightTariffs);
        } else {
            $this->QuotaFlightTariffs = $quotaFlightTariffs;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QuotaFlightItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
