<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricePerAccmd StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PricePerAccmd
 * @subpackage Structs
 */
class PricePerAccmd extends AbstractStructBase
{
    /**
     * The Accommodation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Accommodation
     */
    public $Accommodation;
    /**
     * The OfferHash
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OfferHash;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Price;
    /**
     * The QuotaState_FlightArrival
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QuotaState_FlightArrival;
    /**
     * The QuotaState_FlightDeparture
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QuotaState_FlightDeparture;
    /**
     * The QuotaState_Hotel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QuotaState_Hotel;
    /**
     * Constructor method for PricePerAccmd
     * @uses PricePerAccmd::setAccommodation()
     * @uses PricePerAccmd::setOfferHash()
     * @uses PricePerAccmd::setPrice()
     * @uses PricePerAccmd::setQuotaState_FlightArrival()
     * @uses PricePerAccmd::setQuotaState_FlightDeparture()
     * @uses PricePerAccmd::setQuotaState_Hotel()
     * @param \StructType\Accommodation $accommodation
     * @param string $offerHash
     * @param int $price
     * @param string $quotaState_FlightArrival
     * @param string $quotaState_FlightDeparture
     * @param string $quotaState_Hotel
     */
    public function __construct(\StructType\Accommodation $accommodation = null, $offerHash = null, $price = null, $quotaState_FlightArrival = null, $quotaState_FlightDeparture = null, $quotaState_Hotel = null)
    {
        $this
            ->setAccommodation($accommodation)
            ->setOfferHash($offerHash)
            ->setPrice($price)
            ->setQuotaState_FlightArrival($quotaState_FlightArrival)
            ->setQuotaState_FlightDeparture($quotaState_FlightDeparture)
            ->setQuotaState_Hotel($quotaState_Hotel);
    }
    /**
     * Get Accommodation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Accommodation|null
     */
    public function getAccommodation()
    {
        return isset($this->Accommodation) ? $this->Accommodation : null;
    }
    /**
     * Set Accommodation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Accommodation $accommodation
     * @return \StructType\PricePerAccmd
     */
    public function setAccommodation(\StructType\Accommodation $accommodation = null)
    {
        if (is_null($accommodation) || (is_array($accommodation) && empty($accommodation))) {
            unset($this->Accommodation);
        } else {
            $this->Accommodation = $accommodation;
        }
        return $this;
    }
    /**
     * Get OfferHash value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOfferHash()
    {
        return isset($this->OfferHash) ? $this->OfferHash : null;
    }
    /**
     * Set OfferHash value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $offerHash
     * @return \StructType\PricePerAccmd
     */
    public function setOfferHash($offerHash = null)
    {
        // validation for constraint: string
        if (!is_null($offerHash) && !is_string($offerHash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerHash, true), gettype($offerHash)), __LINE__);
        }
        if (is_null($offerHash) || (is_array($offerHash) && empty($offerHash))) {
            unset($this->OfferHash);
        } else {
            $this->OfferHash = $offerHash;
        }
        return $this;
    }
    /**
     * Get Price value
     * @return int|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param int $price
     * @return \StructType\PricePerAccmd
     */
    public function setPrice($price = null)
    {
        // validation for constraint: int
        if (!is_null($price) && !(is_int($price) || ctype_digit($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get QuotaState_FlightArrival value
     * @return string|null
     */
    public function getQuotaState_FlightArrival()
    {
        return $this->QuotaState_FlightArrival;
    }
    /**
     * Set QuotaState_FlightArrival value
     * @uses \EnumType\QuotaState::valueIsValid()
     * @uses \EnumType\QuotaState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quotaState_FlightArrival
     * @return \StructType\PricePerAccmd
     */
    public function setQuotaState_FlightArrival($quotaState_FlightArrival = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QuotaState::valueIsValid($quotaState_FlightArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\QuotaState', is_array($quotaState_FlightArrival) ? implode(', ', $quotaState_FlightArrival) : var_export($quotaState_FlightArrival, true), implode(', ', \EnumType\QuotaState::getValidValues())), __LINE__);
        }
        $this->QuotaState_FlightArrival = $quotaState_FlightArrival;
        return $this;
    }
    /**
     * Get QuotaState_FlightDeparture value
     * @return string|null
     */
    public function getQuotaState_FlightDeparture()
    {
        return $this->QuotaState_FlightDeparture;
    }
    /**
     * Set QuotaState_FlightDeparture value
     * @uses \EnumType\QuotaState::valueIsValid()
     * @uses \EnumType\QuotaState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quotaState_FlightDeparture
     * @return \StructType\PricePerAccmd
     */
    public function setQuotaState_FlightDeparture($quotaState_FlightDeparture = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QuotaState::valueIsValid($quotaState_FlightDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\QuotaState', is_array($quotaState_FlightDeparture) ? implode(', ', $quotaState_FlightDeparture) : var_export($quotaState_FlightDeparture, true), implode(', ', \EnumType\QuotaState::getValidValues())), __LINE__);
        }
        $this->QuotaState_FlightDeparture = $quotaState_FlightDeparture;
        return $this;
    }
    /**
     * Get QuotaState_Hotel value
     * @return string|null
     */
    public function getQuotaState_Hotel()
    {
        return $this->QuotaState_Hotel;
    }
    /**
     * Set QuotaState_Hotel value
     * @uses \EnumType\QuotaState::valueIsValid()
     * @uses \EnumType\QuotaState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quotaState_Hotel
     * @return \StructType\PricePerAccmd
     */
    public function setQuotaState_Hotel($quotaState_Hotel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QuotaState::valueIsValid($quotaState_Hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\QuotaState', is_array($quotaState_Hotel) ? implode(', ', $quotaState_Hotel) : var_export($quotaState_Hotel, true), implode(', ', \EnumType\QuotaState::getValidValues())), __LINE__);
        }
        $this->QuotaState_Hotel = $quotaState_Hotel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PricePerAccmd
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
