<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Message StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Message
 * @subpackage Structs
 */
class Message extends AbstractStructBase
{
    /**
     * The MessageCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MessageCode;
    /**
     * The MessageText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MessageText;
    /**
     * The MessageType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MessageType;
    /**
     * Constructor method for Message
     * @uses Message::setMessageCode()
     * @uses Message::setMessageText()
     * @uses Message::setMessageType()
     * @param int $messageCode
     * @param string $messageText
     * @param int $messageType
     */
    public function __construct($messageCode = null, $messageText = null, $messageType = null)
    {
        $this
            ->setMessageCode($messageCode)
            ->setMessageText($messageText)
            ->setMessageType($messageType);
    }
    /**
     * Get MessageCode value
     * @return int|null
     */
    public function getMessageCode()
    {
        return $this->MessageCode;
    }
    /**
     * Set MessageCode value
     * @param int $messageCode
     * @return \StructType\Message
     */
    public function setMessageCode($messageCode = null)
    {
        // validation for constraint: int
        if (!is_null($messageCode) && !(is_int($messageCode) || ctype_digit($messageCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($messageCode, true), gettype($messageCode)), __LINE__);
        }
        $this->MessageCode = $messageCode;
        return $this;
    }
    /**
     * Get MessageText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessageText()
    {
        return isset($this->MessageText) ? $this->MessageText : null;
    }
    /**
     * Set MessageText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $messageText
     * @return \StructType\Message
     */
    public function setMessageText($messageText = null)
    {
        // validation for constraint: string
        if (!is_null($messageText) && !is_string($messageText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageText, true), gettype($messageText)), __LINE__);
        }
        if (is_null($messageText) || (is_array($messageText) && empty($messageText))) {
            unset($this->MessageText);
        } else {
            $this->MessageText = $messageText;
        }
        return $this;
    }
    /**
     * Get MessageType value
     * @return int|null
     */
    public function getMessageType()
    {
        return $this->MessageType;
    }
    /**
     * Set MessageType value
     * @param int $messageType
     * @return \StructType\Message
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: int
        if (!is_null($messageType) && !(is_int($messageType) || ctype_digit($messageType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($messageType, true), gettype($messageType)), __LINE__);
        }
        $this->MessageType = $messageType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Message
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
