<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelRoomPrice StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:HotelRoomPrice
 * @subpackage Structs
 */
class HotelRoomPrice extends AbstractStructBase
{
    /**
     * The AdultMax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AdultMax;
    /**
     * The AdultMin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AdultMin;
    /**
     * The AdultPrices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $AdultPrices;
    /**
     * The ChildAsAdult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ChildAsAdult;
    /**
     * The ChildMaxPax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChildMaxPax;
    /**
     * The ChildPrices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfChildPrice
     */
    public $ChildPrices;
    /**
     * The HotelID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HotelID;
    /**
     * The InfantMaxPax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InfantMaxPax;
    /**
     * The PansionID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PansionID;
    /**
     * The PaxMax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaxMax;
    /**
     * The PaxMin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaxMin;
    /**
     * The PricesPerAccmd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPricePerAccmd
     */
    public $PricesPerAccmd;
    /**
     * The RoomCategoryID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RoomCategoryID;
    /**
     * The RoomTypeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RoomTypeID;
    /**
     * Constructor method for HotelRoomPrice
     * @uses HotelRoomPrice::setAdultMax()
     * @uses HotelRoomPrice::setAdultMin()
     * @uses HotelRoomPrice::setAdultPrices()
     * @uses HotelRoomPrice::setChildAsAdult()
     * @uses HotelRoomPrice::setChildMaxPax()
     * @uses HotelRoomPrice::setChildPrices()
     * @uses HotelRoomPrice::setHotelID()
     * @uses HotelRoomPrice::setInfantMaxPax()
     * @uses HotelRoomPrice::setPansionID()
     * @uses HotelRoomPrice::setPaxMax()
     * @uses HotelRoomPrice::setPaxMin()
     * @uses HotelRoomPrice::setPricesPerAccmd()
     * @uses HotelRoomPrice::setRoomCategoryID()
     * @uses HotelRoomPrice::setRoomTypeID()
     * @param string $adultMax
     * @param string $adultMin
     * @param \ArrayType\ArrayOfint $adultPrices
     * @param bool $childAsAdult
     * @param string $childMaxPax
     * @param \ArrayType\ArrayOfChildPrice $childPrices
     * @param int $hotelID
     * @param string $infantMaxPax
     * @param int $pansionID
     * @param string $paxMax
     * @param string $paxMin
     * @param \ArrayType\ArrayOfPricePerAccmd $pricesPerAccmd
     * @param int $roomCategoryID
     * @param int $roomTypeID
     */
    public function __construct($adultMax = null, $adultMin = null, \ArrayType\ArrayOfint $adultPrices = null, $childAsAdult = null, $childMaxPax = null, \ArrayType\ArrayOfChildPrice $childPrices = null, $hotelID = null, $infantMaxPax = null, $pansionID = null, $paxMax = null, $paxMin = null, \ArrayType\ArrayOfPricePerAccmd $pricesPerAccmd = null, $roomCategoryID = null, $roomTypeID = null)
    {
        $this
            ->setAdultMax($adultMax)
            ->setAdultMin($adultMin)
            ->setAdultPrices($adultPrices)
            ->setChildAsAdult($childAsAdult)
            ->setChildMaxPax($childMaxPax)
            ->setChildPrices($childPrices)
            ->setHotelID($hotelID)
            ->setInfantMaxPax($infantMaxPax)
            ->setPansionID($pansionID)
            ->setPaxMax($paxMax)
            ->setPaxMin($paxMin)
            ->setPricesPerAccmd($pricesPerAccmd)
            ->setRoomCategoryID($roomCategoryID)
            ->setRoomTypeID($roomTypeID);
    }
    /**
     * Get AdultMax value
     * @return string|null
     */
    public function getAdultMax()
    {
        return $this->AdultMax;
    }
    /**
     * Set AdultMax value
     * @param string $adultMax
     * @return \StructType\HotelRoomPrice
     */
    public function setAdultMax($adultMax = null)
    {
        // validation for constraint: string
        if (!is_null($adultMax) && !is_string($adultMax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adultMax, true), gettype($adultMax)), __LINE__);
        }
        $this->AdultMax = $adultMax;
        return $this;
    }
    /**
     * Get AdultMin value
     * @return string|null
     */
    public function getAdultMin()
    {
        return $this->AdultMin;
    }
    /**
     * Set AdultMin value
     * @param string $adultMin
     * @return \StructType\HotelRoomPrice
     */
    public function setAdultMin($adultMin = null)
    {
        // validation for constraint: string
        if (!is_null($adultMin) && !is_string($adultMin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adultMin, true), gettype($adultMin)), __LINE__);
        }
        $this->AdultMin = $adultMin;
        return $this;
    }
    /**
     * Get AdultPrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getAdultPrices()
    {
        return isset($this->AdultPrices) ? $this->AdultPrices : null;
    }
    /**
     * Set AdultPrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $adultPrices
     * @return \StructType\HotelRoomPrice
     */
    public function setAdultPrices(\ArrayType\ArrayOfint $adultPrices = null)
    {
        if (is_null($adultPrices) || (is_array($adultPrices) && empty($adultPrices))) {
            unset($this->AdultPrices);
        } else {
            $this->AdultPrices = $adultPrices;
        }
        return $this;
    }
    /**
     * Get ChildAsAdult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getChildAsAdult()
    {
        return isset($this->ChildAsAdult) ? $this->ChildAsAdult : null;
    }
    /**
     * Set ChildAsAdult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $childAsAdult
     * @return \StructType\HotelRoomPrice
     */
    public function setChildAsAdult($childAsAdult = null)
    {
        // validation for constraint: boolean
        if (!is_null($childAsAdult) && !is_bool($childAsAdult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($childAsAdult, true), gettype($childAsAdult)), __LINE__);
        }
        if (is_null($childAsAdult) || (is_array($childAsAdult) && empty($childAsAdult))) {
            unset($this->ChildAsAdult);
        } else {
            $this->ChildAsAdult = $childAsAdult;
        }
        return $this;
    }
    /**
     * Get ChildMaxPax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChildMaxPax()
    {
        return isset($this->ChildMaxPax) ? $this->ChildMaxPax : null;
    }
    /**
     * Set ChildMaxPax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $childMaxPax
     * @return \StructType\HotelRoomPrice
     */
    public function setChildMaxPax($childMaxPax = null)
    {
        // validation for constraint: string
        if (!is_null($childMaxPax) && !is_string($childMaxPax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childMaxPax, true), gettype($childMaxPax)), __LINE__);
        }
        if (is_null($childMaxPax) || (is_array($childMaxPax) && empty($childMaxPax))) {
            unset($this->ChildMaxPax);
        } else {
            $this->ChildMaxPax = $childMaxPax;
        }
        return $this;
    }
    /**
     * Get ChildPrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfChildPrice|null
     */
    public function getChildPrices()
    {
        return isset($this->ChildPrices) ? $this->ChildPrices : null;
    }
    /**
     * Set ChildPrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfChildPrice $childPrices
     * @return \StructType\HotelRoomPrice
     */
    public function setChildPrices(\ArrayType\ArrayOfChildPrice $childPrices = null)
    {
        if (is_null($childPrices) || (is_array($childPrices) && empty($childPrices))) {
            unset($this->ChildPrices);
        } else {
            $this->ChildPrices = $childPrices;
        }
        return $this;
    }
    /**
     * Get HotelID value
     * @return int|null
     */
    public function getHotelID()
    {
        return $this->HotelID;
    }
    /**
     * Set HotelID value
     * @param int $hotelID
     * @return \StructType\HotelRoomPrice
     */
    public function setHotelID($hotelID = null)
    {
        // validation for constraint: int
        if (!is_null($hotelID) && !(is_int($hotelID) || ctype_digit($hotelID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hotelID, true), gettype($hotelID)), __LINE__);
        }
        $this->HotelID = $hotelID;
        return $this;
    }
    /**
     * Get InfantMaxPax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInfantMaxPax()
    {
        return isset($this->InfantMaxPax) ? $this->InfantMaxPax : null;
    }
    /**
     * Set InfantMaxPax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $infantMaxPax
     * @return \StructType\HotelRoomPrice
     */
    public function setInfantMaxPax($infantMaxPax = null)
    {
        // validation for constraint: string
        if (!is_null($infantMaxPax) && !is_string($infantMaxPax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infantMaxPax, true), gettype($infantMaxPax)), __LINE__);
        }
        if (is_null($infantMaxPax) || (is_array($infantMaxPax) && empty($infantMaxPax))) {
            unset($this->InfantMaxPax);
        } else {
            $this->InfantMaxPax = $infantMaxPax;
        }
        return $this;
    }
    /**
     * Get PansionID value
     * @return int|null
     */
    public function getPansionID()
    {
        return $this->PansionID;
    }
    /**
     * Set PansionID value
     * @param int $pansionID
     * @return \StructType\HotelRoomPrice
     */
    public function setPansionID($pansionID = null)
    {
        // validation for constraint: int
        if (!is_null($pansionID) && !(is_int($pansionID) || ctype_digit($pansionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pansionID, true), gettype($pansionID)), __LINE__);
        }
        $this->PansionID = $pansionID;
        return $this;
    }
    /**
     * Get PaxMax value
     * @return string|null
     */
    public function getPaxMax()
    {
        return $this->PaxMax;
    }
    /**
     * Set PaxMax value
     * @param string $paxMax
     * @return \StructType\HotelRoomPrice
     */
    public function setPaxMax($paxMax = null)
    {
        // validation for constraint: string
        if (!is_null($paxMax) && !is_string($paxMax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxMax, true), gettype($paxMax)), __LINE__);
        }
        $this->PaxMax = $paxMax;
        return $this;
    }
    /**
     * Get PaxMin value
     * @return string|null
     */
    public function getPaxMin()
    {
        return $this->PaxMin;
    }
    /**
     * Set PaxMin value
     * @param string $paxMin
     * @return \StructType\HotelRoomPrice
     */
    public function setPaxMin($paxMin = null)
    {
        // validation for constraint: string
        if (!is_null($paxMin) && !is_string($paxMin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxMin, true), gettype($paxMin)), __LINE__);
        }
        $this->PaxMin = $paxMin;
        return $this;
    }
    /**
     * Get PricesPerAccmd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPricePerAccmd|null
     */
    public function getPricesPerAccmd()
    {
        return isset($this->PricesPerAccmd) ? $this->PricesPerAccmd : null;
    }
    /**
     * Set PricesPerAccmd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPricePerAccmd $pricesPerAccmd
     * @return \StructType\HotelRoomPrice
     */
    public function setPricesPerAccmd(\ArrayType\ArrayOfPricePerAccmd $pricesPerAccmd = null)
    {
        if (is_null($pricesPerAccmd) || (is_array($pricesPerAccmd) && empty($pricesPerAccmd))) {
            unset($this->PricesPerAccmd);
        } else {
            $this->PricesPerAccmd = $pricesPerAccmd;
        }
        return $this;
    }
    /**
     * Get RoomCategoryID value
     * @return int|null
     */
    public function getRoomCategoryID()
    {
        return $this->RoomCategoryID;
    }
    /**
     * Set RoomCategoryID value
     * @param int $roomCategoryID
     * @return \StructType\HotelRoomPrice
     */
    public function setRoomCategoryID($roomCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($roomCategoryID) && !(is_int($roomCategoryID) || ctype_digit($roomCategoryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roomCategoryID, true), gettype($roomCategoryID)), __LINE__);
        }
        $this->RoomCategoryID = $roomCategoryID;
        return $this;
    }
    /**
     * Get RoomTypeID value
     * @return int|null
     */
    public function getRoomTypeID()
    {
        return $this->RoomTypeID;
    }
    /**
     * Set RoomTypeID value
     * @param int $roomTypeID
     * @return \StructType\HotelRoomPrice
     */
    public function setRoomTypeID($roomTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($roomTypeID) && !(is_int($roomTypeID) || ctype_digit($roomTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roomTypeID, true), gettype($roomTypeID)), __LINE__);
        }
        $this->RoomTypeID = $roomTypeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelRoomPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
