<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelRoom StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:HotelRoom
 * @subpackage Structs
 */
class HotelRoom extends DictionaryBase
{
    /**
     * The AccommodationID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccommodationID;
    /**
     * The RoomCategoryID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RoomCategoryID;
    /**
     * The RoomTypeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RoomTypeID;
    /**
     * Constructor method for HotelRoom
     * @uses HotelRoom::setAccommodationID()
     * @uses HotelRoom::setRoomCategoryID()
     * @uses HotelRoom::setRoomTypeID()
     * @param int $accommodationID
     * @param int $roomCategoryID
     * @param int $roomTypeID
     */
    public function __construct($accommodationID = null, $roomCategoryID = null, $roomTypeID = null)
    {
        $this
            ->setAccommodationID($accommodationID)
            ->setRoomCategoryID($roomCategoryID)
            ->setRoomTypeID($roomTypeID);
    }
    /**
     * Get AccommodationID value
     * @return int|null
     */
    public function getAccommodationID()
    {
        return $this->AccommodationID;
    }
    /**
     * Set AccommodationID value
     * @param int $accommodationID
     * @return \StructType\HotelRoom
     */
    public function setAccommodationID($accommodationID = null)
    {
        // validation for constraint: int
        if (!is_null($accommodationID) && !(is_int($accommodationID) || ctype_digit($accommodationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accommodationID, true), gettype($accommodationID)), __LINE__);
        }
        $this->AccommodationID = $accommodationID;
        return $this;
    }
    /**
     * Get RoomCategoryID value
     * @return int|null
     */
    public function getRoomCategoryID()
    {
        return $this->RoomCategoryID;
    }
    /**
     * Set RoomCategoryID value
     * @param int $roomCategoryID
     * @return \StructType\HotelRoom
     */
    public function setRoomCategoryID($roomCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($roomCategoryID) && !(is_int($roomCategoryID) || ctype_digit($roomCategoryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roomCategoryID, true), gettype($roomCategoryID)), __LINE__);
        }
        $this->RoomCategoryID = $roomCategoryID;
        return $this;
    }
    /**
     * Get RoomTypeID value
     * @return int|null
     */
    public function getRoomTypeID()
    {
        return $this->RoomTypeID;
    }
    /**
     * Set RoomTypeID value
     * @param int $roomTypeID
     * @return \StructType\HotelRoom
     */
    public function setRoomTypeID($roomTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($roomTypeID) && !(is_int($roomTypeID) || ctype_digit($roomTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roomTypeID, true), gettype($roomTypeID)), __LINE__);
        }
        $this->RoomTypeID = $roomTypeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelRoom
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
