<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetFilter StructType
 * @subpackage Structs
 */
class GetFilter extends AbstractStructBase
{
    /**
     * The countryId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $countryId;
    /**
     * The departureCityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $departureCityId;
    /**
     * The tourTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $tourTypes;
    /**
     * The tours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $tours;
    /**
     * The cities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $cities;
    /**
     * The categories
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $categories;
    /**
     * The hotels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $hotels;
    /**
     * The meals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $meals;
    /**
     * The durations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $durations;
    /**
     * The changedItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $changedItem;
    /**
     * Constructor method for GetFilter
     * @uses GetFilter::setCountryId()
     * @uses GetFilter::setDepartureCityId()
     * @uses GetFilter::setTourTypes()
     * @uses GetFilter::setTours()
     * @uses GetFilter::setCities()
     * @uses GetFilter::setCategories()
     * @uses GetFilter::setHotels()
     * @uses GetFilter::setMeals()
     * @uses GetFilter::setDurations()
     * @uses GetFilter::setChangedItem()
     * @param int $countryId
     * @param \ArrayType\ArrayOfint $departureCityId
     * @param \ArrayType\ArrayOfint $tourTypes
     * @param \ArrayType\ArrayOfint $tours
     * @param \ArrayType\ArrayOfint $cities
     * @param \ArrayType\ArrayOfint $categories
     * @param \ArrayType\ArrayOfint $hotels
     * @param \ArrayType\ArrayOfint $meals
     * @param \ArrayType\ArrayOfint $durations
     * @param string $changedItem
     */
    public function __construct($countryId = null, \ArrayType\ArrayOfint $departureCityId = null, \ArrayType\ArrayOfint $tourTypes = null, \ArrayType\ArrayOfint $tours = null, \ArrayType\ArrayOfint $cities = null, \ArrayType\ArrayOfint $categories = null, \ArrayType\ArrayOfint $hotels = null, \ArrayType\ArrayOfint $meals = null, \ArrayType\ArrayOfint $durations = null, $changedItem = null)
    {
        $this
            ->setCountryId($countryId)
            ->setDepartureCityId($departureCityId)
            ->setTourTypes($tourTypes)
            ->setTours($tours)
            ->setCities($cities)
            ->setCategories($categories)
            ->setHotels($hotels)
            ->setMeals($meals)
            ->setDurations($durations)
            ->setChangedItem($changedItem);
    }
    /**
     * Get countryId value
     * @return int|null
     */
    public function getCountryId()
    {
        return $this->countryId;
    }
    /**
     * Set countryId value
     * @param int $countryId
     * @return \StructType\GetFilter
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: int
        if (!is_null($countryId) && !(is_int($countryId) || ctype_digit($countryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryId, true), gettype($countryId)), __LINE__);
        }
        $this->countryId = $countryId;
        return $this;
    }
    /**
     * Get departureCityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getDepartureCityId()
    {
        return isset($this->departureCityId) ? $this->departureCityId : null;
    }
    /**
     * Set departureCityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $departureCityId
     * @return \StructType\GetFilter
     */
    public function setDepartureCityId(\ArrayType\ArrayOfint $departureCityId = null)
    {
        if (is_null($departureCityId) || (is_array($departureCityId) && empty($departureCityId))) {
            unset($this->departureCityId);
        } else {
            $this->departureCityId = $departureCityId;
        }
        return $this;
    }
    /**
     * Get tourTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getTourTypes()
    {
        return isset($this->tourTypes) ? $this->tourTypes : null;
    }
    /**
     * Set tourTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $tourTypes
     * @return \StructType\GetFilter
     */
    public function setTourTypes(\ArrayType\ArrayOfint $tourTypes = null)
    {
        if (is_null($tourTypes) || (is_array($tourTypes) && empty($tourTypes))) {
            unset($this->tourTypes);
        } else {
            $this->tourTypes = $tourTypes;
        }
        return $this;
    }
    /**
     * Get tours value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getTours()
    {
        return isset($this->tours) ? $this->tours : null;
    }
    /**
     * Set tours value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $tours
     * @return \StructType\GetFilter
     */
    public function setTours(\ArrayType\ArrayOfint $tours = null)
    {
        if (is_null($tours) || (is_array($tours) && empty($tours))) {
            unset($this->tours);
        } else {
            $this->tours = $tours;
        }
        return $this;
    }
    /**
     * Get cities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getCities()
    {
        return isset($this->cities) ? $this->cities : null;
    }
    /**
     * Set cities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $cities
     * @return \StructType\GetFilter
     */
    public function setCities(\ArrayType\ArrayOfint $cities = null)
    {
        if (is_null($cities) || (is_array($cities) && empty($cities))) {
            unset($this->cities);
        } else {
            $this->cities = $cities;
        }
        return $this;
    }
    /**
     * Get categories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getCategories()
    {
        return isset($this->categories) ? $this->categories : null;
    }
    /**
     * Set categories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $categories
     * @return \StructType\GetFilter
     */
    public function setCategories(\ArrayType\ArrayOfint $categories = null)
    {
        if (is_null($categories) || (is_array($categories) && empty($categories))) {
            unset($this->categories);
        } else {
            $this->categories = $categories;
        }
        return $this;
    }
    /**
     * Get hotels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getHotels()
    {
        return isset($this->hotels) ? $this->hotels : null;
    }
    /**
     * Set hotels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $hotels
     * @return \StructType\GetFilter
     */
    public function setHotels(\ArrayType\ArrayOfint $hotels = null)
    {
        if (is_null($hotels) || (is_array($hotels) && empty($hotels))) {
            unset($this->hotels);
        } else {
            $this->hotels = $hotels;
        }
        return $this;
    }
    /**
     * Get meals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getMeals()
    {
        return isset($this->meals) ? $this->meals : null;
    }
    /**
     * Set meals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $meals
     * @return \StructType\GetFilter
     */
    public function setMeals(\ArrayType\ArrayOfint $meals = null)
    {
        if (is_null($meals) || (is_array($meals) && empty($meals))) {
            unset($this->meals);
        } else {
            $this->meals = $meals;
        }
        return $this;
    }
    /**
     * Get durations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getDurations()
    {
        return isset($this->durations) ? $this->durations : null;
    }
    /**
     * Set durations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $durations
     * @return \StructType\GetFilter
     */
    public function setDurations(\ArrayType\ArrayOfint $durations = null)
    {
        if (is_null($durations) || (is_array($durations) && empty($durations))) {
            unset($this->durations);
        } else {
            $this->durations = $durations;
        }
        return $this;
    }
    /**
     * Get changedItem value
     * @return string|null
     */
    public function getChangedItem()
    {
        return $this->changedItem;
    }
    /**
     * Set changedItem value
     * @uses \EnumType\DictionaryEnum::valueIsValid()
     * @uses \EnumType\DictionaryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $changedItem
     * @return \StructType\GetFilter
     */
    public function setChangedItem($changedItem = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DictionaryEnum::valueIsValid($changedItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DictionaryEnum', is_array($changedItem) ? implode(', ', $changedItem) : var_export($changedItem, true), implode(', ', \EnumType\DictionaryEnum::getValidValues())), __LINE__);
        }
        $this->changedItem = $changedItem;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
