<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightProgramItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FlightProgramItem
 * @subpackage Structs
 */
class FlightProgramItem extends AbstractStructBase
{
    /**
     * The FlightServices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfFlightService
     */
    public $FlightServices;
    /**
     * The TourDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TourDate;
    /**
     * The TourDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TourDays;
    /**
     * Constructor method for FlightProgramItem
     * @uses FlightProgramItem::setFlightServices()
     * @uses FlightProgramItem::setTourDate()
     * @uses FlightProgramItem::setTourDays()
     * @param \ArrayType\ArrayOfFlightService $flightServices
     * @param string $tourDate
     * @param string $tourDays
     */
    public function __construct(\ArrayType\ArrayOfFlightService $flightServices = null, $tourDate = null, $tourDays = null)
    {
        $this
            ->setFlightServices($flightServices)
            ->setTourDate($tourDate)
            ->setTourDays($tourDays);
    }
    /**
     * Get FlightServices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfFlightService|null
     */
    public function getFlightServices()
    {
        return isset($this->FlightServices) ? $this->FlightServices : null;
    }
    /**
     * Set FlightServices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfFlightService $flightServices
     * @return \StructType\FlightProgramItem
     */
    public function setFlightServices(\ArrayType\ArrayOfFlightService $flightServices = null)
    {
        if (is_null($flightServices) || (is_array($flightServices) && empty($flightServices))) {
            unset($this->FlightServices);
        } else {
            $this->FlightServices = $flightServices;
        }
        return $this;
    }
    /**
     * Get TourDate value
     * @return string|null
     */
    public function getTourDate()
    {
        return $this->TourDate;
    }
    /**
     * Set TourDate value
     * @param string $tourDate
     * @return \StructType\FlightProgramItem
     */
    public function setTourDate($tourDate = null)
    {
        // validation for constraint: string
        if (!is_null($tourDate) && !is_string($tourDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourDate, true), gettype($tourDate)), __LINE__);
        }
        $this->TourDate = $tourDate;
        return $this;
    }
    /**
     * Get TourDays value
     * @return string|null
     */
    public function getTourDays()
    {
        return $this->TourDays;
    }
    /**
     * Set TourDays value
     * @param string $tourDays
     * @return \StructType\FlightProgramItem
     */
    public function setTourDays($tourDays = null)
    {
        // validation for constraint: string
        if (!is_null($tourDays) && !is_string($tourDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourDays, true), gettype($tourDays)), __LINE__);
        }
        $this->TourDays = $tourDays;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlightProgramItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
