<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FlightInfo
 * @subpackage Structs
 */
class FlightInfo extends AbstractStructBase
{
    /**
     * The AirlineCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AirlineCode;
    /**
     * The ArrivalAirportCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalAirportCode;
    /**
     * The ArrivalCityKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ArrivalCityKey;
    /**
     * The ArrivalCityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalCityName;
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The DepartureAirportCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureAirportCode;
    /**
     * The DepartureCityKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DepartureCityKey;
    /**
     * The DepartureCityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureCityName;
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The FlightClassCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlightClassCode;
    /**
     * The FlightKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FlightKey;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * Constructor method for FlightInfo
     * @uses FlightInfo::setAirlineCode()
     * @uses FlightInfo::setArrivalAirportCode()
     * @uses FlightInfo::setArrivalCityKey()
     * @uses FlightInfo::setArrivalCityName()
     * @uses FlightInfo::setArrivalDateTime()
     * @uses FlightInfo::setDepartureAirportCode()
     * @uses FlightInfo::setDepartureCityKey()
     * @uses FlightInfo::setDepartureCityName()
     * @uses FlightInfo::setDepartureDateTime()
     * @uses FlightInfo::setFlightClassCode()
     * @uses FlightInfo::setFlightKey()
     * @uses FlightInfo::setFlightNumber()
     * @param string $airlineCode
     * @param string $arrivalAirportCode
     * @param int $arrivalCityKey
     * @param string $arrivalCityName
     * @param string $arrivalDateTime
     * @param string $departureAirportCode
     * @param int $departureCityKey
     * @param string $departureCityName
     * @param string $departureDateTime
     * @param string $flightClassCode
     * @param int $flightKey
     * @param string $flightNumber
     */
    public function __construct($airlineCode = null, $arrivalAirportCode = null, $arrivalCityKey = null, $arrivalCityName = null, $arrivalDateTime = null, $departureAirportCode = null, $departureCityKey = null, $departureCityName = null, $departureDateTime = null, $flightClassCode = null, $flightKey = null, $flightNumber = null)
    {
        $this
            ->setAirlineCode($airlineCode)
            ->setArrivalAirportCode($arrivalAirportCode)
            ->setArrivalCityKey($arrivalCityKey)
            ->setArrivalCityName($arrivalCityName)
            ->setArrivalDateTime($arrivalDateTime)
            ->setDepartureAirportCode($departureAirportCode)
            ->setDepartureCityKey($departureCityKey)
            ->setDepartureCityName($departureCityName)
            ->setDepartureDateTime($departureDateTime)
            ->setFlightClassCode($flightClassCode)
            ->setFlightKey($flightKey)
            ->setFlightNumber($flightNumber);
    }
    /**
     * Get AirlineCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAirlineCode()
    {
        return isset($this->AirlineCode) ? $this->AirlineCode : null;
    }
    /**
     * Set AirlineCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $airlineCode
     * @return \StructType\FlightInfo
     */
    public function setAirlineCode($airlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($airlineCode) && !is_string($airlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlineCode, true), gettype($airlineCode)), __LINE__);
        }
        if (is_null($airlineCode) || (is_array($airlineCode) && empty($airlineCode))) {
            unset($this->AirlineCode);
        } else {
            $this->AirlineCode = $airlineCode;
        }
        return $this;
    }
    /**
     * Get ArrivalAirportCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalAirportCode()
    {
        return isset($this->ArrivalAirportCode) ? $this->ArrivalAirportCode : null;
    }
    /**
     * Set ArrivalAirportCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalAirportCode
     * @return \StructType\FlightInfo
     */
    public function setArrivalAirportCode($arrivalAirportCode = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirportCode) && !is_string($arrivalAirportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalAirportCode, true), gettype($arrivalAirportCode)), __LINE__);
        }
        if (is_null($arrivalAirportCode) || (is_array($arrivalAirportCode) && empty($arrivalAirportCode))) {
            unset($this->ArrivalAirportCode);
        } else {
            $this->ArrivalAirportCode = $arrivalAirportCode;
        }
        return $this;
    }
    /**
     * Get ArrivalCityKey value
     * @return int|null
     */
    public function getArrivalCityKey()
    {
        return $this->ArrivalCityKey;
    }
    /**
     * Set ArrivalCityKey value
     * @param int $arrivalCityKey
     * @return \StructType\FlightInfo
     */
    public function setArrivalCityKey($arrivalCityKey = null)
    {
        // validation for constraint: int
        if (!is_null($arrivalCityKey) && !(is_int($arrivalCityKey) || ctype_digit($arrivalCityKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($arrivalCityKey, true), gettype($arrivalCityKey)), __LINE__);
        }
        $this->ArrivalCityKey = $arrivalCityKey;
        return $this;
    }
    /**
     * Get ArrivalCityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalCityName()
    {
        return isset($this->ArrivalCityName) ? $this->ArrivalCityName : null;
    }
    /**
     * Set ArrivalCityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalCityName
     * @return \StructType\FlightInfo
     */
    public function setArrivalCityName($arrivalCityName = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalCityName) && !is_string($arrivalCityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalCityName, true), gettype($arrivalCityName)), __LINE__);
        }
        if (is_null($arrivalCityName) || (is_array($arrivalCityName) && empty($arrivalCityName))) {
            unset($this->ArrivalCityName);
        } else {
            $this->ArrivalCityName = $arrivalCityName;
        }
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \StructType\FlightInfo
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDateTime, true), gettype($arrivalDateTime)), __LINE__);
        }
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get DepartureAirportCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureAirportCode()
    {
        return isset($this->DepartureAirportCode) ? $this->DepartureAirportCode : null;
    }
    /**
     * Set DepartureAirportCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureAirportCode
     * @return \StructType\FlightInfo
     */
    public function setDepartureAirportCode($departureAirportCode = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirportCode) && !is_string($departureAirportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureAirportCode, true), gettype($departureAirportCode)), __LINE__);
        }
        if (is_null($departureAirportCode) || (is_array($departureAirportCode) && empty($departureAirportCode))) {
            unset($this->DepartureAirportCode);
        } else {
            $this->DepartureAirportCode = $departureAirportCode;
        }
        return $this;
    }
    /**
     * Get DepartureCityKey value
     * @return int|null
     */
    public function getDepartureCityKey()
    {
        return $this->DepartureCityKey;
    }
    /**
     * Set DepartureCityKey value
     * @param int $departureCityKey
     * @return \StructType\FlightInfo
     */
    public function setDepartureCityKey($departureCityKey = null)
    {
        // validation for constraint: int
        if (!is_null($departureCityKey) && !(is_int($departureCityKey) || ctype_digit($departureCityKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($departureCityKey, true), gettype($departureCityKey)), __LINE__);
        }
        $this->DepartureCityKey = $departureCityKey;
        return $this;
    }
    /**
     * Get DepartureCityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureCityName()
    {
        return isset($this->DepartureCityName) ? $this->DepartureCityName : null;
    }
    /**
     * Set DepartureCityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureCityName
     * @return \StructType\FlightInfo
     */
    public function setDepartureCityName($departureCityName = null)
    {
        // validation for constraint: string
        if (!is_null($departureCityName) && !is_string($departureCityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureCityName, true), gettype($departureCityName)), __LINE__);
        }
        if (is_null($departureCityName) || (is_array($departureCityName) && empty($departureCityName))) {
            unset($this->DepartureCityName);
        } else {
            $this->DepartureCityName = $departureCityName;
        }
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \StructType\FlightInfo
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateTime) && !is_string($departureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDateTime, true), gettype($departureDateTime)), __LINE__);
        }
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get FlightClassCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlightClassCode()
    {
        return isset($this->FlightClassCode) ? $this->FlightClassCode : null;
    }
    /**
     * Set FlightClassCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flightClassCode
     * @return \StructType\FlightInfo
     */
    public function setFlightClassCode($flightClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($flightClassCode) && !is_string($flightClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightClassCode, true), gettype($flightClassCode)), __LINE__);
        }
        if (is_null($flightClassCode) || (is_array($flightClassCode) && empty($flightClassCode))) {
            unset($this->FlightClassCode);
        } else {
            $this->FlightClassCode = $flightClassCode;
        }
        return $this;
    }
    /**
     * Get FlightKey value
     * @return int|null
     */
    public function getFlightKey()
    {
        return $this->FlightKey;
    }
    /**
     * Set FlightKey value
     * @param int $flightKey
     * @return \StructType\FlightInfo
     */
    public function setFlightKey($flightKey = null)
    {
        // validation for constraint: int
        if (!is_null($flightKey) && !(is_int($flightKey) || ctype_digit($flightKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($flightKey, true), gettype($flightKey)), __LINE__);
        }
        $this->FlightKey = $flightKey;
        return $this;
    }
    /**
     * Get FlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlightNumber()
    {
        return isset($this->FlightNumber) ? $this->FlightNumber : null;
    }
    /**
     * Set FlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flightNumber
     * @return \StructType\FlightInfo
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        if (is_null($flightNumber) || (is_array($flightNumber) && empty($flightNumber))) {
            unset($this->FlightNumber);
        } else {
            $this->FlightNumber = $flightNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlightInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
