<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for City StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:City
 * @subpackage Structs
 */
class City extends DictionaryBase
{
    /**
     * The CountryID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CountryID;
    /**
     * The HotelCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HotelCount;
    /**
     * The IsDeparture
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsDeparture;
    /**
     * The RegionID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RegionID;
    /**
     * Constructor method for City
     * @uses City::setCountryID()
     * @uses City::setHotelCount()
     * @uses City::setIsDeparture()
     * @uses City::setRegionID()
     * @param int $countryID
     * @param int $hotelCount
     * @param bool $isDeparture
     * @param int $regionID
     */
    public function __construct($countryID = null, $hotelCount = null, $isDeparture = null, $regionID = null)
    {
        $this
            ->setCountryID($countryID)
            ->setHotelCount($hotelCount)
            ->setIsDeparture($isDeparture)
            ->setRegionID($regionID);
    }
    /**
     * Get CountryID value
     * @return int|null
     */
    public function getCountryID()
    {
        return $this->CountryID;
    }
    /**
     * Set CountryID value
     * @param int $countryID
     * @return \StructType\City
     */
    public function setCountryID($countryID = null)
    {
        // validation for constraint: int
        if (!is_null($countryID) && !(is_int($countryID) || ctype_digit($countryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryID, true), gettype($countryID)), __LINE__);
        }
        $this->CountryID = $countryID;
        return $this;
    }
    /**
     * Get HotelCount value
     * @return int|null
     */
    public function getHotelCount()
    {
        return $this->HotelCount;
    }
    /**
     * Set HotelCount value
     * @param int $hotelCount
     * @return \StructType\City
     */
    public function setHotelCount($hotelCount = null)
    {
        // validation for constraint: int
        if (!is_null($hotelCount) && !(is_int($hotelCount) || ctype_digit($hotelCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hotelCount, true), gettype($hotelCount)), __LINE__);
        }
        $this->HotelCount = $hotelCount;
        return $this;
    }
    /**
     * Get IsDeparture value
     * @return bool|null
     */
    public function getIsDeparture()
    {
        return $this->IsDeparture;
    }
    /**
     * Set IsDeparture value
     * @param bool $isDeparture
     * @return \StructType\City
     */
    public function setIsDeparture($isDeparture = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeparture) && !is_bool($isDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeparture, true), gettype($isDeparture)), __LINE__);
        }
        $this->IsDeparture = $isDeparture;
        return $this;
    }
    /**
     * Get RegionID value
     * @return int|null
     */
    public function getRegionID()
    {
        return $this->RegionID;
    }
    /**
     * Set RegionID value
     * @param int $regionID
     * @return \StructType\City
     */
    public function setRegionID($regionID = null)
    {
        // validation for constraint: int
        if (!is_null($regionID) && !(is_int($regionID) || ctype_digit($regionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($regionID, true), gettype($regionID)), __LINE__);
        }
        $this->RegionID = $regionID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\City
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
