<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Charter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Charter
 * @subpackage Structs
 */
class Charter extends DictionaryBase
{
    /**
     * The Aircraft
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Aircraft;
    /**
     * The AirlineCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AirlineCode;
    /**
     * The CityArrivalKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CityArrivalKey;
    /**
     * The CityDepartureKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CityDepartureKey;
    /**
     * The CodePortArrival
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodePortArrival;
    /**
     * The CodePortDeparture
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodePortDeparture;
    /**
     * The Flight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Flight;
    /**
     * Constructor method for Charter
     * @uses Charter::setAircraft()
     * @uses Charter::setAirlineCode()
     * @uses Charter::setCityArrivalKey()
     * @uses Charter::setCityDepartureKey()
     * @uses Charter::setCodePortArrival()
     * @uses Charter::setCodePortDeparture()
     * @uses Charter::setFlight()
     * @param string $aircraft
     * @param string $airlineCode
     * @param int $cityArrivalKey
     * @param int $cityDepartureKey
     * @param string $codePortArrival
     * @param string $codePortDeparture
     * @param string $flight
     */
    public function __construct($aircraft = null, $airlineCode = null, $cityArrivalKey = null, $cityDepartureKey = null, $codePortArrival = null, $codePortDeparture = null, $flight = null)
    {
        $this
            ->setAircraft($aircraft)
            ->setAirlineCode($airlineCode)
            ->setCityArrivalKey($cityArrivalKey)
            ->setCityDepartureKey($cityDepartureKey)
            ->setCodePortArrival($codePortArrival)
            ->setCodePortDeparture($codePortDeparture)
            ->setFlight($flight);
    }
    /**
     * Get Aircraft value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAircraft()
    {
        return isset($this->Aircraft) ? $this->Aircraft : null;
    }
    /**
     * Set Aircraft value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aircraft
     * @return \StructType\Charter
     */
    public function setAircraft($aircraft = null)
    {
        // validation for constraint: string
        if (!is_null($aircraft) && !is_string($aircraft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aircraft, true), gettype($aircraft)), __LINE__);
        }
        if (is_null($aircraft) || (is_array($aircraft) && empty($aircraft))) {
            unset($this->Aircraft);
        } else {
            $this->Aircraft = $aircraft;
        }
        return $this;
    }
    /**
     * Get AirlineCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAirlineCode()
    {
        return isset($this->AirlineCode) ? $this->AirlineCode : null;
    }
    /**
     * Set AirlineCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $airlineCode
     * @return \StructType\Charter
     */
    public function setAirlineCode($airlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($airlineCode) && !is_string($airlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlineCode, true), gettype($airlineCode)), __LINE__);
        }
        if (is_null($airlineCode) || (is_array($airlineCode) && empty($airlineCode))) {
            unset($this->AirlineCode);
        } else {
            $this->AirlineCode = $airlineCode;
        }
        return $this;
    }
    /**
     * Get CityArrivalKey value
     * @return int|null
     */
    public function getCityArrivalKey()
    {
        return $this->CityArrivalKey;
    }
    /**
     * Set CityArrivalKey value
     * @param int $cityArrivalKey
     * @return \StructType\Charter
     */
    public function setCityArrivalKey($cityArrivalKey = null)
    {
        // validation for constraint: int
        if (!is_null($cityArrivalKey) && !(is_int($cityArrivalKey) || ctype_digit($cityArrivalKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cityArrivalKey, true), gettype($cityArrivalKey)), __LINE__);
        }
        $this->CityArrivalKey = $cityArrivalKey;
        return $this;
    }
    /**
     * Get CityDepartureKey value
     * @return int|null
     */
    public function getCityDepartureKey()
    {
        return $this->CityDepartureKey;
    }
    /**
     * Set CityDepartureKey value
     * @param int $cityDepartureKey
     * @return \StructType\Charter
     */
    public function setCityDepartureKey($cityDepartureKey = null)
    {
        // validation for constraint: int
        if (!is_null($cityDepartureKey) && !(is_int($cityDepartureKey) || ctype_digit($cityDepartureKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cityDepartureKey, true), gettype($cityDepartureKey)), __LINE__);
        }
        $this->CityDepartureKey = $cityDepartureKey;
        return $this;
    }
    /**
     * Get CodePortArrival value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodePortArrival()
    {
        return isset($this->CodePortArrival) ? $this->CodePortArrival : null;
    }
    /**
     * Set CodePortArrival value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codePortArrival
     * @return \StructType\Charter
     */
    public function setCodePortArrival($codePortArrival = null)
    {
        // validation for constraint: string
        if (!is_null($codePortArrival) && !is_string($codePortArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codePortArrival, true), gettype($codePortArrival)), __LINE__);
        }
        if (is_null($codePortArrival) || (is_array($codePortArrival) && empty($codePortArrival))) {
            unset($this->CodePortArrival);
        } else {
            $this->CodePortArrival = $codePortArrival;
        }
        return $this;
    }
    /**
     * Get CodePortDeparture value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodePortDeparture()
    {
        return isset($this->CodePortDeparture) ? $this->CodePortDeparture : null;
    }
    /**
     * Set CodePortDeparture value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codePortDeparture
     * @return \StructType\Charter
     */
    public function setCodePortDeparture($codePortDeparture = null)
    {
        // validation for constraint: string
        if (!is_null($codePortDeparture) && !is_string($codePortDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codePortDeparture, true), gettype($codePortDeparture)), __LINE__);
        }
        if (is_null($codePortDeparture) || (is_array($codePortDeparture) && empty($codePortDeparture))) {
            unset($this->CodePortDeparture);
        } else {
            $this->CodePortDeparture = $codePortDeparture;
        }
        return $this;
    }
    /**
     * Get Flight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlight()
    {
        return isset($this->Flight) ? $this->Flight : null;
    }
    /**
     * Set Flight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flight
     * @return \StructType\Charter
     */
    public function setFlight($flight = null)
    {
        // validation for constraint: string
        if (!is_null($flight) && !is_string($flight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flight, true), gettype($flight)), __LINE__);
        }
        if (is_null($flight) || (is_array($flight) && empty($flight))) {
            unset($this->Flight);
        } else {
            $this->Flight = $flight;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Charter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
