<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BaseResponse
 * @subpackage Structs
 */
class BaseResponse extends AbstractStructBase
{
    /**
     * The HasErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasErrors;
    /**
     * The Messages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfMessage
     */
    public $Messages;
    /**
     * Constructor method for BaseResponse
     * @uses BaseResponse::setHasErrors()
     * @uses BaseResponse::setMessages()
     * @param bool $hasErrors
     * @param \ArrayType\ArrayOfMessage $messages
     */
    public function __construct($hasErrors = null, \ArrayType\ArrayOfMessage $messages = null)
    {
        $this
            ->setHasErrors($hasErrors)
            ->setMessages($messages);
    }
    /**
     * Get HasErrors value
     * @return bool|null
     */
    public function getHasErrors()
    {
        return $this->HasErrors;
    }
    /**
     * Set HasErrors value
     * @param bool $hasErrors
     * @return \StructType\BaseResponse
     */
    public function setHasErrors($hasErrors = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasErrors) && !is_bool($hasErrors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasErrors, true), gettype($hasErrors)), __LINE__);
        }
        $this->HasErrors = $hasErrors;
        return $this;
    }
    /**
     * Get Messages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfMessage|null
     */
    public function getMessages()
    {
        return isset($this->Messages) ? $this->Messages : null;
    }
    /**
     * Set Messages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfMessage $messages
     * @return \StructType\BaseResponse
     */
    public function setMessages(\ArrayType\ArrayOfMessage $messages = null)
    {
        if (is_null($messages) || (is_array($messages) && empty($messages))) {
            unset($this->Messages);
        } else {
            $this->Messages = $messages;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
