<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Quota ServiceType
 * @subpackage Services
 */
class Quota extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named QuotaHotelsState
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\QuotaHotelsState $parameters
     * @return \StructType\QuotaHotelsStateResponse|bool
     */
    public function QuotaHotelsState(\StructType\QuotaHotelsState $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->QuotaHotelsState($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QuotaFlightsState
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\QuotaFlightsState $parameters
     * @return \StructType\QuotaFlightsStateResponse|bool
     */
    public function QuotaFlightsState(\StructType\QuotaFlightsState $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->QuotaFlightsState($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\QuotaFlightsStateResponse|\StructType\QuotaHotelsStateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
