<?php

namespace EnumType;

/**
 * This class stands for DictionaryEnum EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DictionaryEnum
 * @subpackage Enumerations
 */
class DictionaryEnum
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Country'
     * @return string 'Country'
     */
    const VALUE_COUNTRY = 'Country';
    /**
     * Constant for value 'CityDeparture'
     * @return string 'CityDeparture'
     */
    const VALUE_CITY_DEPARTURE = 'CityDeparture';
    /**
     * Constant for value 'TourType'
     * @return string 'TourType'
     */
    const VALUE_TOUR_TYPE = 'TourType';
    /**
     * Constant for value 'Tour'
     * @return string 'Tour'
     */
    const VALUE_TOUR = 'Tour';
    /**
     * Constant for value 'City'
     * @return string 'City'
     */
    const VALUE_CITY = 'City';
    /**
     * Constant for value 'TourDate'
     * @return string 'TourDate'
     */
    const VALUE_TOUR_DATE = 'TourDate';
    /**
     * Constant for value 'HotelCategory'
     * @return string 'HotelCategory'
     */
    const VALUE_HOTEL_CATEGORY = 'HotelCategory';
    /**
     * Constant for value 'Hotel'
     * @return string 'Hotel'
     */
    const VALUE_HOTEL = 'Hotel';
    /**
     * Constant for value 'Meal'
     * @return string 'Meal'
     */
    const VALUE_MEAL = 'Meal';
    /**
     * Constant for value 'Duration'
     * @return string 'Duration'
     */
    const VALUE_DURATION = 'Duration';
    /**
     * Constant for value 'HotelRoom'
     * @return string 'HotelRoom'
     */
    const VALUE_HOTEL_ROOM = 'HotelRoom';
    /**
     * Constant for value 'RoomCategory'
     * @return string 'RoomCategory'
     */
    const VALUE_ROOM_CATEGORY = 'RoomCategory';
    /**
     * Constant for value 'RoomType'
     * @return string 'RoomType'
     */
    const VALUE_ROOM_TYPE = 'RoomType';
    /**
     * Constant for value 'Accommadation'
     * @return string 'Accommadation'
     */
    const VALUE_ACCOMMADATION = 'Accommadation';
    /**
     * Constant for value 'HotelLink'
     * @return string 'HotelLink'
     */
    const VALUE_HOTEL_LINK = 'HotelLink';
    /**
     * Constant for value 'TouristCountDetail'
     * @return string 'TouristCountDetail'
     */
    const VALUE_TOURIST_COUNT_DETAIL = 'TouristCountDetail';
    /**
     * Constant for value 'HotelCategoryUniq'
     * @return string 'HotelCategoryUniq'
     */
    const VALUE_HOTEL_CATEGORY_UNIQ = 'HotelCategoryUniq';
    /**
     * Constant for value 'MealUniq'
     * @return string 'MealUniq'
     */
    const VALUE_MEAL_UNIQ = 'MealUniq';
    /**
     * Constant for value 'Rate'
     * @return string 'Rate'
     */
    const VALUE_RATE = 'Rate';
    /**
     * Constant for value 'AirLine'
     * @return string 'AirLine'
     */
    const VALUE_AIR_LINE = 'AirLine';
    /**
     * Constant for value 'AirPort'
     * @return string 'AirPort'
     */
    const VALUE_AIR_PORT = 'AirPort';
    /**
     * Constant for value 'AirCraft'
     * @return string 'AirCraft'
     */
    const VALUE_AIR_CRAFT = 'AirCraft';
    /**
     * Constant for value 'AddDescript1'
     * @return string 'AddDescript1'
     */
    const VALUE_ADD_DESCRIPT_1 = 'AddDescript1';
    /**
     * Constant for value 'AddDescript2'
     * @return string 'AddDescript2'
     */
    const VALUE_ADD_DESCRIPT_2 = 'AddDescript2';
    /**
     * Constant for value 'Service'
     * @return string 'Service'
     */
    const VALUE_SERVICE = 'Service';
    /**
     * Constant for value 'Transfer'
     * @return string 'Transfer'
     */
    const VALUE_TRANSFER = 'Transfer';
    /**
     * Constant for value 'Transport'
     * @return string 'Transport'
     */
    const VALUE_TRANSPORT = 'Transport';
    /**
     * Constant for value 'Resort'
     * @return string 'Resort'
     */
    const VALUE_RESORT = 'Resort';
    /**
     * Constant for value 'Flight'
     * @return string 'Flight'
     */
    const VALUE_FLIGHT = 'Flight';
    /**
     * Constant for value 'FlightTariff'
     * @return string 'FlightTariff'
     */
    const VALUE_FLIGHT_TARIFF = 'FlightTariff';
    /**
     * Constant for value 'AirSeason'
     * @return string 'AirSeason'
     */
    const VALUE_AIR_SEASON = 'AirSeason';
    /**
     * Constant for value 'ServiceList'
     * @return string 'ServiceList'
     */
    const VALUE_SERVICE_LIST = 'ServiceList';
    /**
     * Constant for value 'Pax'
     * @return string 'Pax'
     */
    const VALUE_PAX = 'Pax';
    /**
     * Constant for value 'HotelGroup'
     * @return string 'HotelGroup'
     */
    const VALUE_HOTEL_GROUP = 'HotelGroup';
    /**
     * Constant for value 'HotelFacility'
     * @return string 'HotelFacility'
     */
    const VALUE_HOTEL_FACILITY = 'HotelFacility';
    /**
     * Constant for value 'BaseRate'
     * @return string 'BaseRate'
     */
    const VALUE_BASE_RATE = 'BaseRate';
    /**
     * Constant for value 'GdsFilter'
     * @return string 'GdsFilter'
     */
    const VALUE_GDS_FILTER = 'GdsFilter';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_COUNTRY
     * @uses self::VALUE_CITY_DEPARTURE
     * @uses self::VALUE_TOUR_TYPE
     * @uses self::VALUE_TOUR
     * @uses self::VALUE_CITY
     * @uses self::VALUE_TOUR_DATE
     * @uses self::VALUE_HOTEL_CATEGORY
     * @uses self::VALUE_HOTEL
     * @uses self::VALUE_MEAL
     * @uses self::VALUE_DURATION
     * @uses self::VALUE_HOTEL_ROOM
     * @uses self::VALUE_ROOM_CATEGORY
     * @uses self::VALUE_ROOM_TYPE
     * @uses self::VALUE_ACCOMMADATION
     * @uses self::VALUE_HOTEL_LINK
     * @uses self::VALUE_TOURIST_COUNT_DETAIL
     * @uses self::VALUE_HOTEL_CATEGORY_UNIQ
     * @uses self::VALUE_MEAL_UNIQ
     * @uses self::VALUE_RATE
     * @uses self::VALUE_AIR_LINE
     * @uses self::VALUE_AIR_PORT
     * @uses self::VALUE_AIR_CRAFT
     * @uses self::VALUE_ADD_DESCRIPT_1
     * @uses self::VALUE_ADD_DESCRIPT_2
     * @uses self::VALUE_SERVICE
     * @uses self::VALUE_TRANSFER
     * @uses self::VALUE_TRANSPORT
     * @uses self::VALUE_RESORT
     * @uses self::VALUE_FLIGHT
     * @uses self::VALUE_FLIGHT_TARIFF
     * @uses self::VALUE_AIR_SEASON
     * @uses self::VALUE_SERVICE_LIST
     * @uses self::VALUE_PAX
     * @uses self::VALUE_HOTEL_GROUP
     * @uses self::VALUE_HOTEL_FACILITY
     * @uses self::VALUE_BASE_RATE
     * @uses self::VALUE_GDS_FILTER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_COUNTRY,
            self::VALUE_CITY_DEPARTURE,
            self::VALUE_TOUR_TYPE,
            self::VALUE_TOUR,
            self::VALUE_CITY,
            self::VALUE_TOUR_DATE,
            self::VALUE_HOTEL_CATEGORY,
            self::VALUE_HOTEL,
            self::VALUE_MEAL,
            self::VALUE_DURATION,
            self::VALUE_HOTEL_ROOM,
            self::VALUE_ROOM_CATEGORY,
            self::VALUE_ROOM_TYPE,
            self::VALUE_ACCOMMADATION,
            self::VALUE_HOTEL_LINK,
            self::VALUE_TOURIST_COUNT_DETAIL,
            self::VALUE_HOTEL_CATEGORY_UNIQ,
            self::VALUE_MEAL_UNIQ,
            self::VALUE_RATE,
            self::VALUE_AIR_LINE,
            self::VALUE_AIR_PORT,
            self::VALUE_AIR_CRAFT,
            self::VALUE_ADD_DESCRIPT_1,
            self::VALUE_ADD_DESCRIPT_2,
            self::VALUE_SERVICE,
            self::VALUE_TRANSFER,
            self::VALUE_TRANSPORT,
            self::VALUE_RESORT,
            self::VALUE_FLIGHT,
            self::VALUE_FLIGHT_TARIFF,
            self::VALUE_AIR_SEASON,
            self::VALUE_SERVICE_LIST,
            self::VALUE_PAX,
            self::VALUE_HOTEL_GROUP,
            self::VALUE_HOTEL_FACILITY,
            self::VALUE_BASE_RATE,
            self::VALUE_GDS_FILTER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
