<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfReturnObject ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfReturnObject
 * @subpackage Arrays
 */
class ArrayOfReturnObject extends AbstractStructArrayBase
{
    /**
     * The ReturnObject
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReturnObject[]
     */
    public $ReturnObject;
    /**
     * Constructor method for ArrayOfReturnObject
     * @uses ArrayOfReturnObject::setReturnObject()
     * @param \StructType\ReturnObject[] $returnObject
     */
    public function __construct(array $returnObject = array())
    {
        $this
            ->setReturnObject($returnObject);
    }
    /**
     * Get ReturnObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReturnObject[]|null
     */
    public function getReturnObject()
    {
        return isset($this->ReturnObject) ? $this->ReturnObject : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnObject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnObject method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnObjectForArrayConstraintsFromSetReturnObject(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfReturnObjectReturnObjectItem) {
            // validation for constraint: itemType
            if (!$arrayOfReturnObjectReturnObjectItem instanceof \StructType\ReturnObject) {
                $invalidValues[] = is_object($arrayOfReturnObjectReturnObjectItem) ? get_class($arrayOfReturnObjectReturnObjectItem) : sprintf('%s(%s)', gettype($arrayOfReturnObjectReturnObjectItem), var_export($arrayOfReturnObjectReturnObjectItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReturnObject property can only contain items of type \StructType\ReturnObject, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ReturnObject[] $returnObject
     * @return \ArrayType\ArrayOfReturnObject
     */
    public function setReturnObject(array $returnObject = array())
    {
        // validation for constraint: array
        if ('' !== ($returnObjectArrayErrorMessage = self::validateReturnObjectForArrayConstraintsFromSetReturnObject($returnObject))) {
            throw new \InvalidArgumentException($returnObjectArrayErrorMessage, __LINE__);
        }
        if (is_null($returnObject) || (is_array($returnObject) && empty($returnObject))) {
            unset($this->ReturnObject);
        } else {
            $this->ReturnObject = $returnObject;
        }
        return $this;
    }
    /**
     * Add item to ReturnObject value
     * @throws \InvalidArgumentException
     * @param \StructType\ReturnObject $item
     * @return \ArrayType\ArrayOfReturnObject
     */
    public function addToReturnObject(\StructType\ReturnObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReturnObject) {
            throw new \InvalidArgumentException(sprintf('The ReturnObject property can only contain items of type \StructType\ReturnObject, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReturnObject[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ReturnObject|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ReturnObject|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ReturnObject|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ReturnObject|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ReturnObject|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ReturnObject
     */
    public function getAttributeName()
    {
        return 'ReturnObject';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfReturnObject
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
