<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDictionaryEnum ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDictionaryEnum
 * @subpackage Arrays
 */
class ArrayOfDictionaryEnum extends AbstractStructArrayBase
{
    /**
     * The DictionaryEnum
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DictionaryEnum;
    /**
     * Constructor method for ArrayOfDictionaryEnum
     * @uses ArrayOfDictionaryEnum::setDictionaryEnum()
     * @param string[] $dictionaryEnum
     */
    public function __construct(array $dictionaryEnum = array())
    {
        $this
            ->setDictionaryEnum($dictionaryEnum);
    }
    /**
     * Get DictionaryEnum value
     * @return string[]|null
     */
    public function getDictionaryEnum()
    {
        return $this->DictionaryEnum;
    }
    /**
     * This method is responsible for validating the values passed to the setDictionaryEnum method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDictionaryEnum method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDictionaryEnumForArrayConstraintsFromSetDictionaryEnum(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDictionaryEnumDictionaryEnumItem) {
            // validation for constraint: enumeration
            if (!\EnumType\DictionaryEnum::valueIsValid($arrayOfDictionaryEnumDictionaryEnumItem)) {
                $invalidValues[] = is_object($arrayOfDictionaryEnumDictionaryEnumItem) ? get_class($arrayOfDictionaryEnumDictionaryEnumItem) : sprintf('%s(%s)', gettype($arrayOfDictionaryEnumDictionaryEnumItem), var_export($arrayOfDictionaryEnumDictionaryEnumItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DictionaryEnum', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\DictionaryEnum::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DictionaryEnum value
     * @uses \EnumType\DictionaryEnum::valueIsValid()
     * @uses \EnumType\DictionaryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $dictionaryEnum
     * @return \ArrayType\ArrayOfDictionaryEnum
     */
    public function setDictionaryEnum(array $dictionaryEnum = array())
    {
        // validation for constraint: array
        if ('' !== ($dictionaryEnumArrayErrorMessage = self::validateDictionaryEnumForArrayConstraintsFromSetDictionaryEnum($dictionaryEnum))) {
            throw new \InvalidArgumentException($dictionaryEnumArrayErrorMessage, __LINE__);
        }
        $this->DictionaryEnum = $dictionaryEnum;
        return $this;
    }
    /**
     * Add item to DictionaryEnum value
     * @uses \EnumType\DictionaryEnum::valueIsValid()
     * @uses \EnumType\DictionaryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfDictionaryEnum
     */
    public function addToDictionaryEnum($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DictionaryEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DictionaryEnum', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\DictionaryEnum::getValidValues())), __LINE__);
        }
        $this->DictionaryEnum[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\DictionaryEnum::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfDictionaryEnum
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DictionaryEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DictionaryEnum', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\DictionaryEnum::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DictionaryEnum
     */
    public function getAttributeName()
    {
        return 'DictionaryEnum';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDictionaryEnum
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
