<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccommodation ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAccommodation
 * @subpackage Arrays
 */
class ArrayOfAccommodation extends AbstractStructArrayBase
{
    /**
     * The Accommodation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Accommodation[]
     */
    public $Accommodation;
    /**
     * Constructor method for ArrayOfAccommodation
     * @uses ArrayOfAccommodation::setAccommodation()
     * @param \StructType\Accommodation[] $accommodation
     */
    public function __construct(array $accommodation = array())
    {
        $this
            ->setAccommodation($accommodation);
    }
    /**
     * Get Accommodation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Accommodation[]|null
     */
    public function getAccommodation()
    {
        return isset($this->Accommodation) ? $this->Accommodation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccommodation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccommodation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccommodationForArrayConstraintsFromSetAccommodation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAccommodationAccommodationItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccommodationAccommodationItem instanceof \StructType\Accommodation) {
                $invalidValues[] = is_object($arrayOfAccommodationAccommodationItem) ? get_class($arrayOfAccommodationAccommodationItem) : sprintf('%s(%s)', gettype($arrayOfAccommodationAccommodationItem), var_export($arrayOfAccommodationAccommodationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Accommodation property can only contain items of type \StructType\Accommodation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Accommodation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Accommodation[] $accommodation
     * @return \ArrayType\ArrayOfAccommodation
     */
    public function setAccommodation(array $accommodation = array())
    {
        // validation for constraint: array
        if ('' !== ($accommodationArrayErrorMessage = self::validateAccommodationForArrayConstraintsFromSetAccommodation($accommodation))) {
            throw new \InvalidArgumentException($accommodationArrayErrorMessage, __LINE__);
        }
        if (is_null($accommodation) || (is_array($accommodation) && empty($accommodation))) {
            unset($this->Accommodation);
        } else {
            $this->Accommodation = $accommodation;
        }
        return $this;
    }
    /**
     * Add item to Accommodation value
     * @throws \InvalidArgumentException
     * @param \StructType\Accommodation $item
     * @return \ArrayType\ArrayOfAccommodation
     */
    public function addToAccommodation(\StructType\Accommodation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accommodation) {
            throw new \InvalidArgumentException(sprintf('The Accommodation property can only contain items of type \StructType\Accommodation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Accommodation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Accommodation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Accommodation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Accommodation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Accommodation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Accommodation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Accommodation
     */
    public function getAttributeName()
    {
        return 'Accommodation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAccommodation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
