<?php

namespace http://www.segob.gob.mx/dgtic/sapie/webservice/tipoArea\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Eliminar ServiceType
 * @subpackage Services
 */
class Eliminar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named eliminarTipoArea
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \http://www.segob.gob.mx/dgtic/sapie/webservice/tipoArea\StructType\EliminarTipoAreaRequest $eliminarTipoAreaRequest
     * @return \http://www.segob.gob.mx/dgtic/sapie/webservice/tipoArea\StructType\EliminarTipoAreaResponse|bool
     */
    public function eliminarTipoArea(\http://www.segob.gob.mx/dgtic/sapie/webservice/tipoArea\StructType\EliminarTipoAreaRequest $eliminarTipoAreaRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->eliminarTipoArea($eliminarTipoAreaRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \http://www.segob.gob.mx/dgtic/sapie/webservice/tipoArea\StructType\EliminarTipoAreaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
