<?php

namespace http://www.segob.gob.mx/dgtic/sapie/webservice/tipoArea\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Crear ServiceType
 * @subpackage Services
 */
class Crear extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named crearTipoArea
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \http://www.segob.gob.mx/dgtic/sapie/webservice/tipoArea\StructType\CrearTipoAreaRequest $crearTipoAreaRequest
     * @return \http://www.segob.gob.mx/dgtic/sapie/webservice/tipoArea\StructType\CrearTipoAreaResponse|bool
     */
    public function crearTipoArea(\http://www.segob.gob.mx/dgtic/sapie/webservice/tipoArea\StructType\CrearTipoAreaRequest $crearTipoAreaRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->crearTipoArea($crearTipoAreaRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \http://www.segob.gob.mx/dgtic/sapie/webservice/tipoArea\StructType\CrearTipoAreaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
