<?php

namespace http://www.segob.gob.mx/dgtic/sapie/webservice/tipoArea\EnumType;

/**
 * This class stands for tipoFiltro EnumType
 * @subpackage Enumerations
 */
class TipoFiltro
{
    /**
     * Constant for value 'CONTAINS'
     * @return string 'CONTAINS'
     */
    const VALUE_CONTAINS = 'CONTAINS';
    /**
     * Constant for value 'EQUALS'
     * @return string 'EQUALS'
     */
    const VALUE_EQUALS = 'EQUALS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONTAINS
     * @uses self::VALUE_EQUALS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONTAINS,
            self::VALUE_EQUALS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
