<?php

namespace http://www.segob.gob.mx/dgtic/sapie/webservice/tipoArea\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Actualizar ServiceType
 * @subpackage Services
 */
class Actualizar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named actualizarTipoArea
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \http://www.segob.gob.mx/dgtic/sapie/webservice/tipoArea\StructType\ActualizarTipoAreaRequest $actualizarTipoAreaRequest
     * @return \http://www.segob.gob.mx/dgtic/sapie/webservice/tipoArea\StructType\ActualizarTipoAreaResponse|bool
     */
    public function actualizarTipoArea(\http://www.segob.gob.mx/dgtic/sapie/webservice/tipoArea\StructType\ActualizarTipoAreaRequest $actualizarTipoAreaRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->actualizarTipoArea($actualizarTipoAreaRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \http://www.segob.gob.mx/dgtic/sapie/webservice/tipoArea\StructType\ActualizarTipoAreaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
