<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Crear ServiceType
 */
$crear = new \ServiceType\Crear($options);
/**
 * Sample call for crearTipoArea operation/method
 */
if ($crear->crearTipoArea(new \StructType\CrearTipoAreaRequest()) !== false) {
    print_r($crear->getResult());
} else {
    print_r($crear->getLastError());
}
/**
 * Samples for Obtener ServiceType
 */
$obtener = new \ServiceType\Obtener($options);
/**
 * Sample call for obtenerListadoTipoArea operation/method
 */
if ($obtener->obtenerListadoTipoArea(new \StructType\ObtenerListadoTipoAreaRequest()) !== false) {
    print_r($obtener->getResult());
} else {
    print_r($obtener->getLastError());
}
/**
 * Sample call for obtenerTipoAreaPorId operation/method
 */
if ($obtener->obtenerTipoAreaPorId(new \StructType\ObtenerTipoAreaPorIdRequest()) !== false) {
    print_r($obtener->getResult());
} else {
    print_r($obtener->getLastError());
}
/**
 * Samples for Eliminar ServiceType
 */
$eliminar = new \ServiceType\Eliminar($options);
/**
 * Sample call for eliminarTipoArea operation/method
 */
if ($eliminar->eliminarTipoArea(new \StructType\EliminarTipoAreaRequest()) !== false) {
    print_r($eliminar->getResult());
} else {
    print_r($eliminar->getLastError());
}
/**
 * Samples for Actualizar ServiceType
 */
$actualizar = new \ServiceType\Actualizar($options);
/**
 * Sample call for actualizarTipoArea operation/method
 */
if ($actualizar->actualizarTipoArea(new \StructType\ActualizarTipoAreaRequest()) !== false) {
    print_r($actualizar->getResult());
} else {
    print_r($actualizar->getLastError());
}
