<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for obtenerListadoTipoAreaResponse StructType
 * @subpackage Structs
 */
class ObtenerListadoTipoAreaResponse extends AbstractStructBase
{
    /**
     * The tipoAreaDTO
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\TipoAreaDTO[]
     */
    public $tipoAreaDTO;
    /**
     * The totalItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $totalItems;
    /**
     * The mensajeRepuesta
     * @var \StructType\EstadoServicio
     */
    public $mensajeRepuesta;
    /**
     * Constructor method for obtenerListadoTipoAreaResponse
     * @uses ObtenerListadoTipoAreaResponse::setTipoAreaDTO()
     * @uses ObtenerListadoTipoAreaResponse::setTotalItems()
     * @uses ObtenerListadoTipoAreaResponse::setMensajeRepuesta()
     * @param \StructType\TipoAreaDTO[] $tipoAreaDTO
     * @param int $totalItems
     * @param \StructType\EstadoServicio $mensajeRepuesta
     */
    public function __construct(array $tipoAreaDTO = array(), $totalItems = null, \StructType\EstadoServicio $mensajeRepuesta = null)
    {
        $this
            ->setTipoAreaDTO($tipoAreaDTO)
            ->setTotalItems($totalItems)
            ->setMensajeRepuesta($mensajeRepuesta);
    }
    /**
     * Get tipoAreaDTO value
     * @return \StructType\TipoAreaDTO[]|null
     */
    public function getTipoAreaDTO()
    {
        return $this->tipoAreaDTO;
    }
    /**
     * This method is responsible for validating the values passed to the setTipoAreaDTO method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTipoAreaDTO method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTipoAreaDTOForArrayConstraintsFromSetTipoAreaDTO(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $obtenerListadoTipoAreaResponseTipoAreaDTOItem) {
            // validation for constraint: itemType
            if (!$obtenerListadoTipoAreaResponseTipoAreaDTOItem instanceof \StructType\TipoAreaDTO) {
                $invalidValues[] = is_object($obtenerListadoTipoAreaResponseTipoAreaDTOItem) ? get_class($obtenerListadoTipoAreaResponseTipoAreaDTOItem) : sprintf('%s(%s)', gettype($obtenerListadoTipoAreaResponseTipoAreaDTOItem), var_export($obtenerListadoTipoAreaResponseTipoAreaDTOItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The tipoAreaDTO property can only contain items of type \StructType\TipoAreaDTO, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tipoAreaDTO value
     * @throws \InvalidArgumentException
     * @param \StructType\TipoAreaDTO[] $tipoAreaDTO
     * @return \StructType\ObtenerListadoTipoAreaResponse
     */
    public function setTipoAreaDTO(array $tipoAreaDTO = array())
    {
        // validation for constraint: array
        if ('' !== ($tipoAreaDTOArrayErrorMessage = self::validateTipoAreaDTOForArrayConstraintsFromSetTipoAreaDTO($tipoAreaDTO))) {
            throw new \InvalidArgumentException($tipoAreaDTOArrayErrorMessage, __LINE__);
        }
        $this->tipoAreaDTO = $tipoAreaDTO;
        return $this;
    }
    /**
     * Add item to tipoAreaDTO value
     * @throws \InvalidArgumentException
     * @param \StructType\TipoAreaDTO $item
     * @return \StructType\ObtenerListadoTipoAreaResponse
     */
    public function addToTipoAreaDTO(\StructType\TipoAreaDTO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TipoAreaDTO) {
            throw new \InvalidArgumentException(sprintf('The tipoAreaDTO property can only contain items of type \StructType\TipoAreaDTO, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->tipoAreaDTO[] = $item;
        return $this;
    }
    /**
     * Get totalItems value
     * @return int|null
     */
    public function getTotalItems()
    {
        return $this->totalItems;
    }
    /**
     * Set totalItems value
     * @param int $totalItems
     * @return \StructType\ObtenerListadoTipoAreaResponse
     */
    public function setTotalItems($totalItems = null)
    {
        // validation for constraint: int
        if (!is_null($totalItems) && !(is_int($totalItems) || ctype_digit($totalItems))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalItems, true), gettype($totalItems)), __LINE__);
        }
        $this->totalItems = $totalItems;
        return $this;
    }
    /**
     * Get mensajeRepuesta value
     * @return \StructType\EstadoServicio|null
     */
    public function getMensajeRepuesta()
    {
        return $this->mensajeRepuesta;
    }
    /**
     * Set mensajeRepuesta value
     * @param \StructType\EstadoServicio $mensajeRepuesta
     * @return \StructType\ObtenerListadoTipoAreaResponse
     */
    public function setMensajeRepuesta(\StructType\EstadoServicio $mensajeRepuesta = null)
    {
        $this->mensajeRepuesta = $mensajeRepuesta;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ObtenerListadoTipoAreaResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
