<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Obtener ServiceType
 * @subpackage Services
 */
class Obtener extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named obtenerListadoTipoArea
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObtenerListadoTipoAreaRequest $obtenerListadoTipoAreaRequest
     * @return \StructType\ObtenerListadoTipoAreaResponse|bool
     */
    public function obtenerListadoTipoArea(\StructType\ObtenerListadoTipoAreaRequest $obtenerListadoTipoAreaRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->obtenerListadoTipoArea($obtenerListadoTipoAreaRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obtenerTipoAreaPorId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObtenerTipoAreaPorIdRequest $obtenerTipoAreaPorIdRequest
     * @return \StructType\ObtenerTipoAreaPorIdResponse|bool
     */
    public function obtenerTipoAreaPorId(\StructType\ObtenerTipoAreaPorIdRequest $obtenerTipoAreaPorIdRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->obtenerTipoAreaPorId($obtenerTipoAreaPorIdRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ObtenerListadoTipoAreaResponse|\StructType\ObtenerTipoAreaPorIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
