<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paginado StructType
 * @subpackage Structs
 */
class Paginado extends AbstractStructBase
{
    /**
     * The pagina
     * @var int
     */
    public $pagina;
    /**
     * The filasPorPagina
     * @var int
     */
    public $filasPorPagina;
    /**
     * The ordenadoPor
     * @var string
     */
    public $ordenadoPor;
    /**
     * Constructor method for paginado
     * @uses Paginado::setPagina()
     * @uses Paginado::setFilasPorPagina()
     * @uses Paginado::setOrdenadoPor()
     * @param int $pagina
     * @param int $filasPorPagina
     * @param string $ordenadoPor
     */
    public function __construct($pagina = null, $filasPorPagina = null, $ordenadoPor = null)
    {
        $this
            ->setPagina($pagina)
            ->setFilasPorPagina($filasPorPagina)
            ->setOrdenadoPor($ordenadoPor);
    }
    /**
     * Get pagina value
     * @return int|null
     */
    public function getPagina()
    {
        return $this->pagina;
    }
    /**
     * Set pagina value
     * @param int $pagina
     * @return \StructType\Paginado
     */
    public function setPagina($pagina = null)
    {
        // validation for constraint: int
        if (!is_null($pagina) && !(is_int($pagina) || ctype_digit($pagina))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pagina, true), gettype($pagina)), __LINE__);
        }
        $this->pagina = $pagina;
        return $this;
    }
    /**
     * Get filasPorPagina value
     * @return int|null
     */
    public function getFilasPorPagina()
    {
        return $this->filasPorPagina;
    }
    /**
     * Set filasPorPagina value
     * @param int $filasPorPagina
     * @return \StructType\Paginado
     */
    public function setFilasPorPagina($filasPorPagina = null)
    {
        // validation for constraint: int
        if (!is_null($filasPorPagina) && !(is_int($filasPorPagina) || ctype_digit($filasPorPagina))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($filasPorPagina, true), gettype($filasPorPagina)), __LINE__);
        }
        $this->filasPorPagina = $filasPorPagina;
        return $this;
    }
    /**
     * Get ordenadoPor value
     * @return string|null
     */
    public function getOrdenadoPor()
    {
        return $this->ordenadoPor;
    }
    /**
     * Set ordenadoPor value
     * @param string $ordenadoPor
     * @return \StructType\Paginado
     */
    public function setOrdenadoPor($ordenadoPor = null)
    {
        // validation for constraint: string
        if (!is_null($ordenadoPor) && !is_string($ordenadoPor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ordenadoPor, true), gettype($ordenadoPor)), __LINE__);
        }
        $this->ordenadoPor = $ordenadoPor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Paginado
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
