<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructQueryResellerAccount StructType
 * @subpackage Structs
 */
class StructQueryResellerAccount extends AbstractStructBase
{
    /**
     * The BalanceAmount
     * @var string
     */
    public $BalanceAmount;
    /**
     * The BalanceLowLimit
     * @var string
     */
    public $BalanceLowLimit;
    /**
     * The BalanceHardLimit
     * @var string
     */
    public $BalanceHardLimit;
    /**
     * Constructor method for StructQueryResellerAccount
     * @uses StructQueryResellerAccount::setBalanceAmount()
     * @uses StructQueryResellerAccount::setBalanceLowLimit()
     * @uses StructQueryResellerAccount::setBalanceHardLimit()
     * @param string $balanceAmount
     * @param string $balanceLowLimit
     * @param string $balanceHardLimit
     */
    public function __construct($balanceAmount = null, $balanceLowLimit = null, $balanceHardLimit = null)
    {
        $this
            ->setBalanceAmount($balanceAmount)
            ->setBalanceLowLimit($balanceLowLimit)
            ->setBalanceHardLimit($balanceHardLimit);
    }
    /**
     * Get BalanceAmount value
     * @return string|null
     */
    public function getBalanceAmount()
    {
        return $this->BalanceAmount;
    }
    /**
     * Set BalanceAmount value
     * @param string $balanceAmount
     * @return \netim\StructType\StructQueryResellerAccount
     */
    public function setBalanceAmount($balanceAmount = null)
    {
        // validation for constraint: string
        if (!is_null($balanceAmount) && !is_string($balanceAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($balanceAmount)), __LINE__);
        }
        $this->BalanceAmount = $balanceAmount;
        return $this;
    }
    /**
     * Get BalanceLowLimit value
     * @return string|null
     */
    public function getBalanceLowLimit()
    {
        return $this->BalanceLowLimit;
    }
    /**
     * Set BalanceLowLimit value
     * @param string $balanceLowLimit
     * @return \netim\StructType\StructQueryResellerAccount
     */
    public function setBalanceLowLimit($balanceLowLimit = null)
    {
        // validation for constraint: string
        if (!is_null($balanceLowLimit) && !is_string($balanceLowLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($balanceLowLimit)), __LINE__);
        }
        $this->BalanceLowLimit = $balanceLowLimit;
        return $this;
    }
    /**
     * Get BalanceHardLimit value
     * @return string|null
     */
    public function getBalanceHardLimit()
    {
        return $this->BalanceHardLimit;
    }
    /**
     * Set BalanceHardLimit value
     * @param string $balanceHardLimit
     * @return \netim\StructType\StructQueryResellerAccount
     */
    public function setBalanceHardLimit($balanceHardLimit = null)
    {
        // validation for constraint: string
        if (!is_null($balanceHardLimit) && !is_string($balanceHardLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($balanceHardLimit)), __LINE__);
        }
        $this->BalanceHardLimit = $balanceHardLimit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructQueryResellerAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
