<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructQueryMarkList StructType
 * @subpackage Structs
 */
class StructQueryMarkList extends AbstractStructBase
{
    /**
     * The markId
     * @var string
     */
    public $markId;
    /**
     * The markName
     * @var string
     */
    public $markName;
    /**
     * Constructor method for StructQueryMarkList
     * @uses StructQueryMarkList::setMarkId()
     * @uses StructQueryMarkList::setMarkName()
     * @param string $markId
     * @param string $markName
     */
    public function __construct($markId = null, $markName = null)
    {
        $this
            ->setMarkId($markId)
            ->setMarkName($markName);
    }
    /**
     * Get markId value
     * @return string|null
     */
    public function getMarkId()
    {
        return $this->markId;
    }
    /**
     * Set markId value
     * @param string $markId
     * @return \netim\StructType\StructQueryMarkList
     */
    public function setMarkId($markId = null)
    {
        // validation for constraint: string
        if (!is_null($markId) && !is_string($markId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($markId)), __LINE__);
        }
        $this->markId = $markId;
        return $this;
    }
    /**
     * Get markName value
     * @return string|null
     */
    public function getMarkName()
    {
        return $this->markName;
    }
    /**
     * Set markName value
     * @param string $markName
     * @return \netim\StructType\StructQueryMarkList
     */
    public function setMarkName($markName = null)
    {
        // validation for constraint: string
        if (!is_null($markName) && !is_string($markName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($markName)), __LINE__);
        }
        $this->markName = $markName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructQueryMarkList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
