<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructQueryDomainPrice StructType
 * @subpackage Structs
 */
class StructQueryDomainPrice extends AbstractStructBase
{
    /**
     * The FeeCurrency
     * @var string
     */
    public $FeeCurrency;
    /**
     * The Fee4Registration
     * @var string
     */
    public $Fee4Registration;
    /**
     * The Fee4Renewal
     * @var string
     */
    public $Fee4Renewal;
    /**
     * The Fee4Transfer
     * @var string
     */
    public $Fee4Transfer;
    /**
     * The Fee4Trade
     * @var string
     */
    public $Fee4Trade;
    /**
     * The Fee4Restore
     * @var string
     */
    public $Fee4Restore;
    /**
     * The Fee4TrusteeService
     * @var string
     */
    public $Fee4TrusteeService;
    /**
     * The Fee4LocalContactService
     * @var string
     */
    public $Fee4LocalContactService;
    /**
     * The IsPremium
     * @var int
     */
    public $IsPremium;
    /**
     * Constructor method for StructQueryDomainPrice
     * @uses StructQueryDomainPrice::setFeeCurrency()
     * @uses StructQueryDomainPrice::setFee4Registration()
     * @uses StructQueryDomainPrice::setFee4Renewal()
     * @uses StructQueryDomainPrice::setFee4Transfer()
     * @uses StructQueryDomainPrice::setFee4Trade()
     * @uses StructQueryDomainPrice::setFee4Restore()
     * @uses StructQueryDomainPrice::setFee4TrusteeService()
     * @uses StructQueryDomainPrice::setFee4LocalContactService()
     * @uses StructQueryDomainPrice::setIsPremium()
     * @param string $feeCurrency
     * @param string $fee4Registration
     * @param string $fee4Renewal
     * @param string $fee4Transfer
     * @param string $fee4Trade
     * @param string $fee4Restore
     * @param string $fee4TrusteeService
     * @param string $fee4LocalContactService
     * @param int $isPremium
     */
    public function __construct($feeCurrency = null, $fee4Registration = null, $fee4Renewal = null, $fee4Transfer = null, $fee4Trade = null, $fee4Restore = null, $fee4TrusteeService = null, $fee4LocalContactService = null, $isPremium = null)
    {
        $this
            ->setFeeCurrency($feeCurrency)
            ->setFee4Registration($fee4Registration)
            ->setFee4Renewal($fee4Renewal)
            ->setFee4Transfer($fee4Transfer)
            ->setFee4Trade($fee4Trade)
            ->setFee4Restore($fee4Restore)
            ->setFee4TrusteeService($fee4TrusteeService)
            ->setFee4LocalContactService($fee4LocalContactService)
            ->setIsPremium($isPremium);
    }
    /**
     * Get FeeCurrency value
     * @return string|null
     */
    public function getFeeCurrency()
    {
        return $this->FeeCurrency;
    }
    /**
     * Set FeeCurrency value
     * @param string $feeCurrency
     * @return \netim\StructType\StructQueryDomainPrice
     */
    public function setFeeCurrency($feeCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($feeCurrency) && !is_string($feeCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feeCurrency)), __LINE__);
        }
        $this->FeeCurrency = $feeCurrency;
        return $this;
    }
    /**
     * Get Fee4Registration value
     * @return string|null
     */
    public function getFee4Registration()
    {
        return $this->Fee4Registration;
    }
    /**
     * Set Fee4Registration value
     * @param string $fee4Registration
     * @return \netim\StructType\StructQueryDomainPrice
     */
    public function setFee4Registration($fee4Registration = null)
    {
        // validation for constraint: string
        if (!is_null($fee4Registration) && !is_string($fee4Registration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fee4Registration)), __LINE__);
        }
        $this->Fee4Registration = $fee4Registration;
        return $this;
    }
    /**
     * Get Fee4Renewal value
     * @return string|null
     */
    public function getFee4Renewal()
    {
        return $this->Fee4Renewal;
    }
    /**
     * Set Fee4Renewal value
     * @param string $fee4Renewal
     * @return \netim\StructType\StructQueryDomainPrice
     */
    public function setFee4Renewal($fee4Renewal = null)
    {
        // validation for constraint: string
        if (!is_null($fee4Renewal) && !is_string($fee4Renewal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fee4Renewal)), __LINE__);
        }
        $this->Fee4Renewal = $fee4Renewal;
        return $this;
    }
    /**
     * Get Fee4Transfer value
     * @return string|null
     */
    public function getFee4Transfer()
    {
        return $this->Fee4Transfer;
    }
    /**
     * Set Fee4Transfer value
     * @param string $fee4Transfer
     * @return \netim\StructType\StructQueryDomainPrice
     */
    public function setFee4Transfer($fee4Transfer = null)
    {
        // validation for constraint: string
        if (!is_null($fee4Transfer) && !is_string($fee4Transfer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fee4Transfer)), __LINE__);
        }
        $this->Fee4Transfer = $fee4Transfer;
        return $this;
    }
    /**
     * Get Fee4Trade value
     * @return string|null
     */
    public function getFee4Trade()
    {
        return $this->Fee4Trade;
    }
    /**
     * Set Fee4Trade value
     * @param string $fee4Trade
     * @return \netim\StructType\StructQueryDomainPrice
     */
    public function setFee4Trade($fee4Trade = null)
    {
        // validation for constraint: string
        if (!is_null($fee4Trade) && !is_string($fee4Trade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fee4Trade)), __LINE__);
        }
        $this->Fee4Trade = $fee4Trade;
        return $this;
    }
    /**
     * Get Fee4Restore value
     * @return string|null
     */
    public function getFee4Restore()
    {
        return $this->Fee4Restore;
    }
    /**
     * Set Fee4Restore value
     * @param string $fee4Restore
     * @return \netim\StructType\StructQueryDomainPrice
     */
    public function setFee4Restore($fee4Restore = null)
    {
        // validation for constraint: string
        if (!is_null($fee4Restore) && !is_string($fee4Restore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fee4Restore)), __LINE__);
        }
        $this->Fee4Restore = $fee4Restore;
        return $this;
    }
    /**
     * Get Fee4TrusteeService value
     * @return string|null
     */
    public function getFee4TrusteeService()
    {
        return $this->Fee4TrusteeService;
    }
    /**
     * Set Fee4TrusteeService value
     * @param string $fee4TrusteeService
     * @return \netim\StructType\StructQueryDomainPrice
     */
    public function setFee4TrusteeService($fee4TrusteeService = null)
    {
        // validation for constraint: string
        if (!is_null($fee4TrusteeService) && !is_string($fee4TrusteeService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fee4TrusteeService)), __LINE__);
        }
        $this->Fee4TrusteeService = $fee4TrusteeService;
        return $this;
    }
    /**
     * Get Fee4LocalContactService value
     * @return string|null
     */
    public function getFee4LocalContactService()
    {
        return $this->Fee4LocalContactService;
    }
    /**
     * Set Fee4LocalContactService value
     * @param string $fee4LocalContactService
     * @return \netim\StructType\StructQueryDomainPrice
     */
    public function setFee4LocalContactService($fee4LocalContactService = null)
    {
        // validation for constraint: string
        if (!is_null($fee4LocalContactService) && !is_string($fee4LocalContactService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fee4LocalContactService)), __LINE__);
        }
        $this->Fee4LocalContactService = $fee4LocalContactService;
        return $this;
    }
    /**
     * Get IsPremium value
     * @return int|null
     */
    public function getIsPremium()
    {
        return $this->IsPremium;
    }
    /**
     * Set IsPremium value
     * @param int $isPremium
     * @return \netim\StructType\StructQueryDomainPrice
     */
    public function setIsPremium($isPremium = null)
    {
        // validation for constraint: int
        if (!is_null($isPremium) && !is_numeric($isPremium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isPremium)), __LINE__);
        }
        $this->IsPremium = $isPremium;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructQueryDomainPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
