<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructHostingMailFwdInfo StructType
 * @subpackage Structs
 */
class StructHostingMailFwdInfo extends AbstractStructBase
{
    /**
     * The mail
     * @var string
     */
    public $mail;
    /**
     * The mailFwd
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $mailFwd;
    /**
     * Constructor method for StructHostingMailFwdInfo
     * @uses StructHostingMailFwdInfo::setMail()
     * @uses StructHostingMailFwdInfo::setMailFwd()
     * @param string $mail
     * @param string[] $mailFwd
     */
    public function __construct($mail = null, array $mailFwd = array())
    {
        $this
            ->setMail($mail)
            ->setMailFwd($mailFwd);
    }
    /**
     * Get mail value
     * @return string|null
     */
    public function getMail()
    {
        return $this->mail;
    }
    /**
     * Set mail value
     * @param string $mail
     * @return \netim\StructType\StructHostingMailFwdInfo
     */
    public function setMail($mail = null)
    {
        // validation for constraint: string
        if (!is_null($mail) && !is_string($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mail)), __LINE__);
        }
        $this->mail = $mail;
        return $this;
    }
    /**
     * Get mailFwd value
     * @return string[]|null
     */
    public function getMailFwd()
    {
        return $this->mailFwd;
    }
    /**
     * Set mailFwd value
     * @throws \InvalidArgumentException
     * @param string[] $mailFwd
     * @return \netim\StructType\StructHostingMailFwdInfo
     */
    public function setMailFwd(array $mailFwd = array())
    {
        foreach ($mailFwd as $structHostingMailFwdInfoMailFwdItem) {
            // validation for constraint: itemType
            if (!is_string($structHostingMailFwdInfoMailFwdItem)) {
                throw new \InvalidArgumentException(sprintf('The mailFwd property can only contain items of string, "%s" given', is_object($structHostingMailFwdInfoMailFwdItem) ? get_class($structHostingMailFwdInfoMailFwdItem) : gettype($structHostingMailFwdInfoMailFwdItem)), __LINE__);
            }
        }
        $this->mailFwd = $mailFwd;
        return $this;
    }
    /**
     * Add item to mailFwd value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \netim\StructType\StructHostingMailFwdInfo
     */
    public function addToMailFwd($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The mailFwd property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->mailFwd[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructHostingMailFwdInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
