<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructHostingMailDomainAliasesInfo StructType
 * @subpackage Structs
 */
class StructHostingMailDomainAliasesInfo extends AbstractStructBase
{
    /**
     * The domain
     * @var string
     */
    public $domain;
    /**
     * The domainAlias
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $domainAlias;
    /**
     * Constructor method for StructHostingMailDomainAliasesInfo
     * @uses StructHostingMailDomainAliasesInfo::setDomain()
     * @uses StructHostingMailDomainAliasesInfo::setDomainAlias()
     * @param string $domain
     * @param string[] $domainAlias
     */
    public function __construct($domain = null, array $domainAlias = array())
    {
        $this
            ->setDomain($domain)
            ->setDomainAlias($domainAlias);
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \netim\StructType\StructHostingMailDomainAliasesInfo
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get domainAlias value
     * @return string[]|null
     */
    public function getDomainAlias()
    {
        return $this->domainAlias;
    }
    /**
     * Set domainAlias value
     * @throws \InvalidArgumentException
     * @param string[] $domainAlias
     * @return \netim\StructType\StructHostingMailDomainAliasesInfo
     */
    public function setDomainAlias(array $domainAlias = array())
    {
        foreach ($domainAlias as $structHostingMailDomainAliasesInfoDomainAliasItem) {
            // validation for constraint: itemType
            if (!is_string($structHostingMailDomainAliasesInfoDomainAliasItem)) {
                throw new \InvalidArgumentException(sprintf('The domainAlias property can only contain items of string, "%s" given', is_object($structHostingMailDomainAliasesInfoDomainAliasItem) ? get_class($structHostingMailDomainAliasesInfoDomainAliasItem) : gettype($structHostingMailDomainAliasesInfoDomainAliasItem)), __LINE__);
            }
        }
        $this->domainAlias = $domainAlias;
        return $this;
    }
    /**
     * Add item to domainAlias value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \netim\StructType\StructHostingMailDomainAliasesInfo
     */
    public function addToDomainAlias($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The domainAlias property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->domainAlias[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructHostingMailDomainAliasesInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
