<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructHostingMailAliasesInfo StructType
 * @subpackage Structs
 */
class StructHostingMailAliasesInfo extends AbstractStructBase
{
    /**
     * The mail
     * @var string
     */
    public $mail;
    /**
     * The mailAlias
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $mailAlias;
    /**
     * Constructor method for StructHostingMailAliasesInfo
     * @uses StructHostingMailAliasesInfo::setMail()
     * @uses StructHostingMailAliasesInfo::setMailAlias()
     * @param string $mail
     * @param string[] $mailAlias
     */
    public function __construct($mail = null, array $mailAlias = array())
    {
        $this
            ->setMail($mail)
            ->setMailAlias($mailAlias);
    }
    /**
     * Get mail value
     * @return string|null
     */
    public function getMail()
    {
        return $this->mail;
    }
    /**
     * Set mail value
     * @param string $mail
     * @return \netim\StructType\StructHostingMailAliasesInfo
     */
    public function setMail($mail = null)
    {
        // validation for constraint: string
        if (!is_null($mail) && !is_string($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mail)), __LINE__);
        }
        $this->mail = $mail;
        return $this;
    }
    /**
     * Get mailAlias value
     * @return string[]|null
     */
    public function getMailAlias()
    {
        return $this->mailAlias;
    }
    /**
     * Set mailAlias value
     * @throws \InvalidArgumentException
     * @param string[] $mailAlias
     * @return \netim\StructType\StructHostingMailAliasesInfo
     */
    public function setMailAlias(array $mailAlias = array())
    {
        foreach ($mailAlias as $structHostingMailAliasesInfoMailAliasItem) {
            // validation for constraint: itemType
            if (!is_string($structHostingMailAliasesInfoMailAliasItem)) {
                throw new \InvalidArgumentException(sprintf('The mailAlias property can only contain items of string, "%s" given', is_object($structHostingMailAliasesInfoMailAliasItem) ? get_class($structHostingMailAliasesInfoMailAliasItem) : gettype($structHostingMailAliasesInfoMailAliasItem)), __LINE__);
            }
        }
        $this->mailAlias = $mailAlias;
        return $this;
    }
    /**
     * Add item to mailAlias value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \netim\StructType\StructHostingMailAliasesInfo
     */
    public function addToMailAlias($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The mailAlias property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->mailAlias[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructHostingMailAliasesInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
