<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructHostingList StructType
 * @subpackage Structs
 */
class StructHostingList extends AbstractStructBase
{
    /**
     * The hosting
     * @var string
     */
    public $hosting;
    /**
     * The dateCreate
     * @var string
     */
    public $dateCreate;
    /**
     * The dateExpiration
     * @var string
     */
    public $dateExpiration;
    /**
     * Constructor method for StructHostingList
     * @uses StructHostingList::setHosting()
     * @uses StructHostingList::setDateCreate()
     * @uses StructHostingList::setDateExpiration()
     * @param string $hosting
     * @param string $dateCreate
     * @param string $dateExpiration
     */
    public function __construct($hosting = null, $dateCreate = null, $dateExpiration = null)
    {
        $this
            ->setHosting($hosting)
            ->setDateCreate($dateCreate)
            ->setDateExpiration($dateExpiration);
    }
    /**
     * Get hosting value
     * @return string|null
     */
    public function getHosting()
    {
        return $this->hosting;
    }
    /**
     * Set hosting value
     * @param string $hosting
     * @return \netim\StructType\StructHostingList
     */
    public function setHosting($hosting = null)
    {
        // validation for constraint: string
        if (!is_null($hosting) && !is_string($hosting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hosting)), __LINE__);
        }
        $this->hosting = $hosting;
        return $this;
    }
    /**
     * Get dateCreate value
     * @return string|null
     */
    public function getDateCreate()
    {
        return $this->dateCreate;
    }
    /**
     * Set dateCreate value
     * @param string $dateCreate
     * @return \netim\StructType\StructHostingList
     */
    public function setDateCreate($dateCreate = null)
    {
        // validation for constraint: string
        if (!is_null($dateCreate) && !is_string($dateCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateCreate)), __LINE__);
        }
        $this->dateCreate = $dateCreate;
        return $this;
    }
    /**
     * Get dateExpiration value
     * @return string|null
     */
    public function getDateExpiration()
    {
        return $this->dateExpiration;
    }
    /**
     * Set dateExpiration value
     * @param string $dateExpiration
     * @return \netim\StructType\StructHostingList
     */
    public function setDateExpiration($dateExpiration = null)
    {
        // validation for constraint: string
        if (!is_null($dateExpiration) && !is_string($dateExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateExpiration)), __LINE__);
        }
        $this->dateExpiration = $dateExpiration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructHostingList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
