<?php

namespace netim\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructHostingInfo StructType
 * @subpackage Structs
 */
class StructHostingInfo extends AbstractStructBase
{
    /**
     * The domain
     * @var string
     */
    public $domain;
    /**
     * The dateCreate
     * @var string
     */
    public $dateCreate;
    /**
     * The dateExpiration
     * @var string
     */
    public $dateExpiration;
    /**
     * The dateMaxRenew
     * @var string
     */
    public $dateMaxRenew;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The autoRenew
     * @var int
     */
    public $autoRenew;
    /**
     * The panel
     * @var string
     */
    public $panel;
    /**
     * The login
     * @var string
     */
    public $login;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The language
     * @var string
     */
    public $language;
    /**
     * The offer
     * @var string
     */
    public $offer;
    /**
     * Constructor method for StructHostingInfo
     * @uses StructHostingInfo::setDomain()
     * @uses StructHostingInfo::setDateCreate()
     * @uses StructHostingInfo::setDateExpiration()
     * @uses StructHostingInfo::setDateMaxRenew()
     * @uses StructHostingInfo::setStatus()
     * @uses StructHostingInfo::setAutoRenew()
     * @uses StructHostingInfo::setPanel()
     * @uses StructHostingInfo::setLogin()
     * @uses StructHostingInfo::setPassword()
     * @uses StructHostingInfo::setLanguage()
     * @uses StructHostingInfo::setOffer()
     * @param string $domain
     * @param string $dateCreate
     * @param string $dateExpiration
     * @param string $dateMaxRenew
     * @param string $status
     * @param int $autoRenew
     * @param string $panel
     * @param string $login
     * @param string $password
     * @param string $language
     * @param string $offer
     */
    public function __construct($domain = null, $dateCreate = null, $dateExpiration = null, $dateMaxRenew = null, $status = null, $autoRenew = null, $panel = null, $login = null, $password = null, $language = null, $offer = null)
    {
        $this
            ->setDomain($domain)
            ->setDateCreate($dateCreate)
            ->setDateExpiration($dateExpiration)
            ->setDateMaxRenew($dateMaxRenew)
            ->setStatus($status)
            ->setAutoRenew($autoRenew)
            ->setPanel($panel)
            ->setLogin($login)
            ->setPassword($password)
            ->setLanguage($language)
            ->setOffer($offer);
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \netim\StructType\StructHostingInfo
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get dateCreate value
     * @return string|null
     */
    public function getDateCreate()
    {
        return $this->dateCreate;
    }
    /**
     * Set dateCreate value
     * @param string $dateCreate
     * @return \netim\StructType\StructHostingInfo
     */
    public function setDateCreate($dateCreate = null)
    {
        // validation for constraint: string
        if (!is_null($dateCreate) && !is_string($dateCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateCreate)), __LINE__);
        }
        $this->dateCreate = $dateCreate;
        return $this;
    }
    /**
     * Get dateExpiration value
     * @return string|null
     */
    public function getDateExpiration()
    {
        return $this->dateExpiration;
    }
    /**
     * Set dateExpiration value
     * @param string $dateExpiration
     * @return \netim\StructType\StructHostingInfo
     */
    public function setDateExpiration($dateExpiration = null)
    {
        // validation for constraint: string
        if (!is_null($dateExpiration) && !is_string($dateExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateExpiration)), __LINE__);
        }
        $this->dateExpiration = $dateExpiration;
        return $this;
    }
    /**
     * Get dateMaxRenew value
     * @return string|null
     */
    public function getDateMaxRenew()
    {
        return $this->dateMaxRenew;
    }
    /**
     * Set dateMaxRenew value
     * @param string $dateMaxRenew
     * @return \netim\StructType\StructHostingInfo
     */
    public function setDateMaxRenew($dateMaxRenew = null)
    {
        // validation for constraint: string
        if (!is_null($dateMaxRenew) && !is_string($dateMaxRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateMaxRenew)), __LINE__);
        }
        $this->dateMaxRenew = $dateMaxRenew;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \netim\StructType\StructHostingInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get autoRenew value
     * @return int|null
     */
    public function getAutoRenew()
    {
        return $this->autoRenew;
    }
    /**
     * Set autoRenew value
     * @param int $autoRenew
     * @return \netim\StructType\StructHostingInfo
     */
    public function setAutoRenew($autoRenew = null)
    {
        // validation for constraint: int
        if (!is_null($autoRenew) && !is_numeric($autoRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($autoRenew)), __LINE__);
        }
        $this->autoRenew = $autoRenew;
        return $this;
    }
    /**
     * Get panel value
     * @return string|null
     */
    public function getPanel()
    {
        return $this->panel;
    }
    /**
     * Set panel value
     * @param string $panel
     * @return \netim\StructType\StructHostingInfo
     */
    public function setPanel($panel = null)
    {
        // validation for constraint: string
        if (!is_null($panel) && !is_string($panel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($panel)), __LINE__);
        }
        $this->panel = $panel;
        return $this;
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \netim\StructType\StructHostingInfo
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \netim\StructType\StructHostingInfo
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \netim\StructType\StructHostingInfo
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get offer value
     * @return string|null
     */
    public function getOffer()
    {
        return $this->offer;
    }
    /**
     * Set offer value
     * @param string $offer
     * @return \netim\StructType\StructHostingInfo
     */
    public function setOffer($offer = null)
    {
        // validation for constraint: string
        if (!is_null($offer) && !is_string($offer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($offer)), __LINE__);
        }
        $this->offer = $offer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \netim\StructType\StructHostingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
