<?php

namespace netim\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Tmch ServiceType
 * @subpackage Services
 */
class Tmch extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named tmchMarkCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $markName
     * @param string $markType
     * @param string $duration
     * @param string $idOwner
     * @param \netim\ArrayType\ArrayOfKeyValueData $complementaryInformations
     * @return int|bool
     */
    public function tmchMarkCreate($iDSession, $markName, $markType, $duration, $idOwner, \netim\ArrayType\ArrayOfKeyValueData $complementaryInformations)
    {
        try {
            $this->setResult(self::getSoapClient()->tmchMarkCreate($iDSession, $markName, $markType, $duration, $idOwner, $complementaryInformations));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named tmchMarkUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $markId
     * @param string $markType
     * @param \netim\ArrayType\ArrayOfKeyValueData $complementaryInformations
     * @return int|bool
     */
    public function tmchMarkUpdate($iDSession, $markId, $markType, \netim\ArrayType\ArrayOfKeyValueData $complementaryInformations)
    {
        try {
            $this->setResult(self::getSoapClient()->tmchMarkUpdate($iDSession, $markId, $markType, $complementaryInformations));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named tmchMarkUpdateOwner
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $markId
     * @param string $typeOwner
     * @param \netim\StructType\StructOwner $structOwner
     * @return int|bool
     */
    public function tmchMarkUpdateOwner($iDSession, $markId, $typeOwner, \netim\StructType\StructOwner $structOwner)
    {
        try {
            $this->setResult(self::getSoapClient()->tmchMarkUpdateOwner($iDSession, $markId, $typeOwner, $structOwner));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named tmchMarkRenew
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $markId
     * @param string $duration
     * @return int|bool
     */
    public function tmchMarkRenew($iDSession, $markId, $duration)
    {
        try {
            $this->setResult(self::getSoapClient()->tmchMarkRenew($iDSession, $markId, $duration));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named tmchMarkInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $markId
     * @return \netim\StructType\StructTmchMarkInfo|bool
     */
    public function tmchMarkInfo($iDSession, $markId)
    {
        try {
            $this->setResult(self::getSoapClient()->tmchMarkInfo($iDSession, $markId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named tmchMarkGetSMD
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $markId
     * @return int|bool
     */
    public function tmchMarkGetSMD($iDSession, $markId)
    {
        try {
            $this->setResult(self::getSoapClient()->tmchMarkGetSMD($iDSession, $markId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named tmchLabelCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $markId
     * @param string $labelName
     * @param string $smdInclusion
     * @param string $claimsNotify
     * @return int|bool
     */
    public function tmchLabelCreate($iDSession, $markId, $labelName, $smdInclusion, $claimsNotify)
    {
        try {
            $this->setResult(self::getSoapClient()->tmchLabelCreate($iDSession, $markId, $labelName, $smdInclusion, $claimsNotify));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named tmchLabelUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $markId
     * @param string $labelName
     * @param string $smdInclusion
     * @param string $claimsNotify
     * @return int|bool
     */
    public function tmchLabelUpdate($iDSession, $markId, $labelName, $smdInclusion, $claimsNotify)
    {
        try {
            $this->setResult(self::getSoapClient()->tmchLabelUpdate($iDSession, $markId, $labelName, $smdInclusion, $claimsNotify));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named tmchLabelDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $markId
     * @param string $labelName
     * @return int|bool
     */
    public function tmchLabelDelete($iDSession, $markId, $labelName)
    {
        try {
            $this->setResult(self::getSoapClient()->tmchLabelDelete($iDSession, $markId, $labelName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named tmchLabelInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDSession
     * @param string $markId
     * @param string $labelName
     * @return \netim\StructType\StructTmchLabelInfo|bool
     */
    public function tmchLabelInfo($iDSession, $markId, $labelName)
    {
        try {
            $this->setResult(self::getSoapClient()->tmchLabelInfo($iDSession, $markId, $labelName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return int|\netim\StructType\StructTmchLabelInfo|\netim\StructType\StructTmchMarkInfo
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
