<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \netim\ClassMap::get(),
);
/**
 * Samples for Login ServiceType
 */
$login = new \netim\ServiceType\Login($options);
/**
 * Sample call for login operation/method
 */
if ($login->login($idReseller, $password, $language, $source) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \netim\ServiceType\Logout($options);
/**
 * Sample call for logout operation/method
 */
if ($logout->logout($IDSession) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
/**
 * Samples for Hello ServiceType
 */
$hello = new \netim\ServiceType\Hello($options);
/**
 * Sample call for hello operation/method
 */
if ($hello->hello($IDSession) !== false) {
    print_r($hello->getResult());
} else {
    print_r($hello->getLastError());
}
/**
 * Samples for Domain ServiceType
 */
$domain = new \netim\ServiceType\Domain($options);
/**
 * Sample call for domainWhois operation/method
 */
if ($domain->domainWhois($IDSession, $domain) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainCheck operation/method
 */
if ($domain->domainCheck($IDSession, $domain) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainCreate operation/method
 */
if ($domain->domainCreate($IDSession, $domain, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5, $duration, $templateDNS) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainCreateLP operation/method
 */
if ($domain->domainCreateLP($IDSession, $domain, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5, $duration, $launchPhase) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainInfo operation/method
 */
if ($domain->domainInfo($IDSession, $domain) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainTldInfo operation/method
 */
if ($domain->domainTldInfo($IDSession, $tld) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainAuthID operation/method
 */
if ($domain->domainAuthID($IDSession, $domain, $sendtoregistrant) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainSetMembership operation/method
 */
if ($domain->domainSetMembership($IDSession, $domain, $token) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainChangeContact operation/method
 */
if ($domain->domainChangeContact($IDSession, $domain, $idAdmin, $idTech, $idBilling) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainChangeDNS operation/method
 */
if ($domain->domainChangeDNS($IDSession, $domain, $ns1, $ns2, $ns3, $ns4, $ns5) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainSetDNSSec operation/method
 */
if ($domain->domainSetDNSSec($IDSession, $domain, $enable) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainSetDNSSecExt operation/method
 */
if ($domain->domainSetDNSSecExt($IDSession, $domain, $DSRecords, $flags, $protocol, $algo, $pubKey) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainRenew operation/method
 */
if ($domain->domainRenew($IDSession, $domain, $duration) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainRelease operation/method
 */
if ($domain->domainRelease($IDSession, $domain) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainRestore operation/method
 */
if ($domain->domainRestore($IDSession, $domain) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainTransferIn operation/method
 */
if ($domain->domainTransferIn($IDSession, $domain, $authID, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainTransferTrade operation/method
 */
if ($domain->domainTransferTrade($IDSession, $domain, $authID, $idOwner, $idAdmin, $idTech, $idBilling, $ns1, $ns2, $ns3, $ns4, $ns5) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainTransferOwner operation/method
 */
if ($domain->domainTransferOwner($IDSession, $domain, $idOwner) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainUpdateOwner operation/method
 */
if ($domain->domainUpdateOwner($IDSession, $domain, new \netim\StructType\StructOwner()) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainSetPreference operation/method
 */
if ($domain->domainSetPreference($IDSession, $domain, $codePref, $enable) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainDelete operation/method
 */
if ($domain->domainDelete($IDSession, $domain, $typeDelete) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainMailFwdCreate operation/method
 */
if ($domain->domainMailFwdCreate($IDSession, $mailBox, $recipients) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainMailFwdDelete operation/method
 */
if ($domain->domainMailFwdDelete($IDSession, $mailBox) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainWebFwdCreate operation/method
 */
if ($domain->domainWebFwdCreate($IDSession, $FQDN, $target, $type, new \netim\StructType\StructOptionsFwd()) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainWebFwdDelete operation/method
 */
if ($domain->domainWebFwdDelete($IDSession, $FQDN) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainZoneCreate operation/method
 */
if ($domain->domainZoneCreate($IDSession, $domain, $subdomain, $type, $value, new \netim\StructType\StructOptionsZone()) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainZoneDelete operation/method
 */
if ($domain->domainZoneDelete($IDSession, $domain, $subdomain, $type, $value) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainZoneInit operation/method
 */
if ($domain->domainZoneInit($IDSession, $domain, $numTemplate) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Sample call for domainZoneInitSoa operation/method
 */
if ($domain->domainZoneInitSoa($IDSession, $domain, $ttl, $ttlUnity, $refresh, $refreshUnity, $retry, $retryUnity, $expire, $expireUnity, $minimum, $minimumUnity) !== false) {
    print_r($domain->getResult());
} else {
    print_r($domain->getLastError());
}
/**
 * Samples for Query ServiceType
 */
$query = new \netim\ServiceType\Query($options);
/**
 * Sample call for queryOpeList operation/method
 */
if ($query->queryOpeList($IDSession, $ext) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryDomainList operation/method
 */
if ($query->queryDomainList($IDSession, $filter) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryDomainPrice operation/method
 */
if ($query->queryDomainPrice($IDSession, $domain, $authID) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryDomainClaim operation/method
 */
if ($query->queryDomainClaim($IDSession, $domain) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryOpe operation/method
 */
if ($query->queryOpe($IDSession, $numOperation) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryContactList operation/method
 */
if ($query->queryContactList($IDSession, $filter, $field) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryZoneList operation/method
 */
if ($query->queryZoneList($IDSession, $domain) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryMailFwdList operation/method
 */
if ($query->queryMailFwdList($IDSession, $domain) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryWebFwdList operation/method
 */
if ($query->queryWebFwdList($IDSession, $domain) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryHostingList operation/method
 */
if ($query->queryHostingList($IDSession, $filter) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryHostingMailList operation/method
 */
if ($query->queryHostingMailList($IDSession, $domain) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryHostingMailAliasList operation/method
 */
if ($query->queryHostingMailAliasList($IDSession, $domain) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryHostingMailFwdList operation/method
 */
if ($query->queryHostingMailFwdList($IDSession, $domain) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryMarkList operation/method
 */
if ($query->queryMarkList($IDSession) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryLabelList operation/method
 */
if ($query->queryLabelList($IDSession, $markId) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryAllowedLabelList operation/method
 */
if ($query->queryAllowedLabelList($IDSession, $markId) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryResellerAccount operation/method
 */
if ($query->queryResellerAccount($IDSession) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryOpePending operation/method
 */
if ($query->queryOpePending($IDSession) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \netim\ServiceType\Cancel($options);
/**
 * Sample call for cancelOpe operation/method
 */
if ($cancel->cancelOpe($IDSession, $numOperation) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Contact ServiceType
 */
$contact = new \netim\ServiceType\Contact($options);
/**
 * Sample call for contactCreate operation/method
 */
if ($contact->contactCreate($IDSession, new \netim\StructType\StructContact()) !== false) {
    print_r($contact->getResult());
} else {
    print_r($contact->getLastError());
}
/**
 * Sample call for contactInfo operation/method
 */
if ($contact->contactInfo($IDSession, $IDIdentifiant) !== false) {
    print_r($contact->getResult());
} else {
    print_r($contact->getLastError());
}
/**
 * Sample call for contactUpdate operation/method
 */
if ($contact->contactUpdate($IDSession, $idContact, new \netim\StructType\StructContact()) !== false) {
    print_r($contact->getResult());
} else {
    print_r($contact->getLastError());
}
/**
 * Samples for Website ServiceType
 */
$website = new \netim\ServiceType\Website($options);
/**
 * Sample call for websiteCreate operation/method
 */
if ($website->websiteCreate($IDSession, $fqdn, $prod, $duration) !== false) {
    print_r($website->getResult());
} else {
    print_r($website->getLastError());
}
/**
 * Sample call for websiteRenew operation/method
 */
if ($website->websiteRenew($IDSession, $fqdn, $prod, $duration) !== false) {
    print_r($website->getResult());
} else {
    print_r($website->getLastError());
}
/**
 * Sample call for websiteGetControlPanelURL operation/method
 */
if ($website->websiteGetControlPanelURL($IDSession, $fqdn) !== false) {
    print_r($website->getResult());
} else {
    print_r($website->getLastError());
}
/**
 * Sample call for websiteSetPreference operation/method
 */
if ($website->websiteSetPreference($IDSession, $fqdn, $code, $value) !== false) {
    print_r($website->getResult());
} else {
    print_r($website->getLastError());
}
/**
 * Sample call for websiteDelete operation/method
 */
if ($website->websiteDelete($IDSession, $fqdn) !== false) {
    print_r($website->getResult());
} else {
    print_r($website->getLastError());
}
/**
 * Samples for Host ServiceType
 */
$host = new \netim\ServiceType\Host($options);
/**
 * Sample call for hostCreate operation/method
 */
if ($host->hostCreate($IDSession, $host, $ipv4, $ipv6) !== false) {
    print_r($host->getResult());
} else {
    print_r($host->getLastError());
}
/**
 * Sample call for hostDelete operation/method
 */
if ($host->hostDelete($IDSession, $host) !== false) {
    print_r($host->getResult());
} else {
    print_r($host->getLastError());
}
/**
 * Sample call for hostUpdate operation/method
 */
if ($host->hostUpdate($IDSession, $host, $ipv4, $ipv6) !== false) {
    print_r($host->getResult());
} else {
    print_r($host->getLastError());
}
/**
 * Samples for Hosting ServiceType
 */
$hosting = new \netim\ServiceType\Hosting($options);
/**
 * Sample call for hostingSetPreference operation/method
 */
if ($hosting->hostingSetPreference($IDSession, $domain, $code, $value, $additional) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingCreate operation/method
 */
if ($hosting->hostingCreate($IDSession, $domain, $prod, $duration, $lang) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingDelete operation/method
 */
if ($hosting->hostingDelete($IDSession, $domain, $typeDelete) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingRenew operation/method
 */
if ($hosting->hostingRenew($IDSession, $domain, $duration) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingUpgrade operation/method
 */
if ($hosting->hostingUpgrade($IDSession, $domain, $prod) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingInfo operation/method
 */
if ($hosting->hostingInfo($IDSession, $domain) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingMailCreate operation/method
 */
if ($hosting->hostingMailCreate($IDSession, $mail, $password, $realname, $quota, $cc) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingMailDelete operation/method
 */
if ($hosting->hostingMailDelete($IDSession, $mail) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingMailSetPreference operation/method
 */
if ($hosting->hostingMailSetPreference($IDSession, $mail, $code, $value) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingMailInfo operation/method
 */
if ($hosting->hostingMailInfo($IDSession, $mail) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingMailDomainAliasCreate operation/method
 */
if ($hosting->hostingMailDomainAliasCreate($IDSession, $domain, $domainAlias) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingMailDomainAliasDelete operation/method
 */
if ($hosting->hostingMailDomainAliasDelete($IDSession, $domain, $domainAlias) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingMailDomainAliasesInfo operation/method
 */
if ($hosting->hostingMailDomainAliasesInfo($IDSession, $domain) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingMailAliasCreate operation/method
 */
if ($hosting->hostingMailAliasCreate($IDSession, $mail, $mailAlias) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingMailAliasDelete operation/method
 */
if ($hosting->hostingMailAliasDelete($IDSession, $mail, $mailAlias) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingMailAliasesInfo operation/method
 */
if ($hosting->hostingMailAliasesInfo($IDSession, $mail, $mailAlias) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingMailFwdCreate operation/method
 */
if ($hosting->hostingMailFwdCreate($IDSession, $mail, $mailForward) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingMailFwdDelete operation/method
 */
if ($hosting->hostingMailFwdDelete($IDSession, $mail, $mailForward) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingMailFwdInfo operation/method
 */
if ($hosting->hostingMailFwdInfo($IDSession, $mail) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingMailCatchallCreate operation/method
 */
if ($hosting->hostingMailCatchallCreate($IDSession, $domain, $mail) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingMailCatchallDelete operation/method
 */
if ($hosting->hostingMailCatchallDelete($IDSession, $domain) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Sample call for hostingMailCatchallInfo operation/method
 */
if ($hosting->hostingMailCatchallInfo($IDSession, $domain) !== false) {
    print_r($hosting->getResult());
} else {
    print_r($hosting->getLastError());
}
/**
 * Samples for Tmch ServiceType
 */
$tmch = new \netim\ServiceType\Tmch($options);
/**
 * Sample call for tmchMarkCreate operation/method
 */
if ($tmch->tmchMarkCreate($IDSession, $markName, $markType, $duration, $idOwner, new \netim\ArrayType\ArrayOfKeyValueData()) !== false) {
    print_r($tmch->getResult());
} else {
    print_r($tmch->getLastError());
}
/**
 * Sample call for tmchMarkUpdate operation/method
 */
if ($tmch->tmchMarkUpdate($IDSession, $markId, $markType, new \netim\ArrayType\ArrayOfKeyValueData()) !== false) {
    print_r($tmch->getResult());
} else {
    print_r($tmch->getLastError());
}
/**
 * Sample call for tmchMarkUpdateOwner operation/method
 */
if ($tmch->tmchMarkUpdateOwner($IDSession, $markId, $typeOwner, new \netim\StructType\StructOwner()) !== false) {
    print_r($tmch->getResult());
} else {
    print_r($tmch->getLastError());
}
/**
 * Sample call for tmchMarkRenew operation/method
 */
if ($tmch->tmchMarkRenew($IDSession, $markId, $duration) !== false) {
    print_r($tmch->getResult());
} else {
    print_r($tmch->getLastError());
}
/**
 * Sample call for tmchMarkInfo operation/method
 */
if ($tmch->tmchMarkInfo($IDSession, $markId) !== false) {
    print_r($tmch->getResult());
} else {
    print_r($tmch->getLastError());
}
/**
 * Sample call for tmchMarkGetSMD operation/method
 */
if ($tmch->tmchMarkGetSMD($IDSession, $markId) !== false) {
    print_r($tmch->getResult());
} else {
    print_r($tmch->getLastError());
}
/**
 * Sample call for tmchLabelCreate operation/method
 */
if ($tmch->tmchLabelCreate($IDSession, $markId, $labelName, $smdInclusion, $claimsNotify) !== false) {
    print_r($tmch->getResult());
} else {
    print_r($tmch->getLastError());
}
/**
 * Sample call for tmchLabelUpdate operation/method
 */
if ($tmch->tmchLabelUpdate($IDSession, $markId, $labelName, $smdInclusion, $claimsNotify) !== false) {
    print_r($tmch->getResult());
} else {
    print_r($tmch->getLastError());
}
/**
 * Sample call for tmchLabelDelete operation/method
 */
if ($tmch->tmchLabelDelete($IDSession, $markId, $labelName) !== false) {
    print_r($tmch->getResult());
} else {
    print_r($tmch->getLastError());
}
/**
 * Sample call for tmchLabelInfo operation/method
 */
if ($tmch->tmchLabelInfo($IDSession, $markId, $labelName) !== false) {
    print_r($tmch->getResult());
} else {
    print_r($tmch->getLastError());
}
